/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.guice.NestedDataModule;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.segment.AutoTypeColumnIndexer;
import org.apache.druid.segment.AutoTypeColumnMerger;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringEncodingStrategy;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.index.semantic.ArrayElementIndexes;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedDataColumnSupplierTest;
import org.apache.druid.segment.nested.NestedFieldColumnIndexSupplierTest;
import org.apache.druid.segment.nested.SortedValueDictionary;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.nested.VariantColumn;
import org.apache.druid.segment.nested.VariantColumnAndIndexSupplier;
import org.apache.druid.segment.nested.VariantColumnSerializer;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VariantColumnSupplierTest
extends InitializedNullHandlingTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    BitmapSerdeFactory bitmapSerdeFactory = RoaringBitmapSerdeFactory.getInstance();
    DefaultBitmapResultFactory resultFactory = new DefaultBitmapResultFactory(this.bitmapSerdeFactory.getBitmapFactory());
    static List<List<Long>> LONG_ARRAY = Arrays.asList(Collections.emptyList(), Arrays.asList(1L, null, 2L), null, Collections.singletonList(null), Arrays.asList(3L, 4L), Arrays.asList(null, null));
    static List<List<Double>> DOUBLE_ARRAY = Arrays.asList(Collections.emptyList(), Arrays.asList(1.1, null, 2.2), null, Collections.singletonList(null), Arrays.asList(3.3, 4.4), Arrays.asList(null, null));
    static List<List<String>> STRING_ARRAY = Arrays.asList(Collections.emptyList(), Arrays.asList("a", null, "b"), null, Collections.singletonList(null), Arrays.asList("c", "d"), Arrays.asList(null, null));
    static List<Object> VARIANT_NUMERIC = Arrays.asList(1L, 2.2, null, 3.3, 4L, null);
    static List<Object> VARIANT_SCALAR = Arrays.asList(null, 1L, null, "b", 3.3, 4L);
    static List<Object> VARIANT_SCALAR_AND_ARRAY = Arrays.asList(Collections.emptyList(), 2L, null, Collections.singletonList(null), Arrays.asList(3L, 4L), Arrays.asList(null, "a"), 5.5, "b");
    static List<List<Object>> VARIANT_ARRAY = Arrays.asList(Collections.emptyList(), Arrays.asList("a", null, "b"), null, Collections.singletonList(null), Arrays.asList(3L, 4L), Arrays.asList(null, 3.3));
    static List<List<Object>> NO_TYPE_ARRAY = Arrays.asList(Collections.emptyList(), null, Collections.emptyList(), Arrays.asList(null, null));
    Closer closer = Closer.create();
    SmooshedFileMapper fileMapper;
    ByteBuffer baseBuffer;
    FieldTypeInfo.MutableTypeSet expectedTypes;
    ColumnType expectedLogicalType = null;
    private final List<?> data;
    private final IndexSpec indexSpec;

    @BeforeClass
    public static void staticSetup() {
        NestedDataModule.registerHandlersAndSerde();
    }

    @Parameterized.Parameters(name="data = {0}")
    public static Collection<?> constructorFeeder() {
        IndexSpec fancy = IndexSpec.builder().withLongEncoding(CompressionFactory.LongEncodingStrategy.AUTO).withStringDictionaryEncoding((StringEncodingStrategy)new StringEncodingStrategy.FrontCoded(Integer.valueOf(16), Byte.valueOf((byte)1))).build();
        ImmutableList constructors = ImmutableList.of((Object)new Object[]{"ARRAY<LONG>", LONG_ARRAY, IndexSpec.DEFAULT}, (Object)new Object[]{"ARRAY<LONG>", LONG_ARRAY, fancy}, (Object)new Object[]{"ARRAY<DOUBLE>", DOUBLE_ARRAY, IndexSpec.DEFAULT}, (Object)new Object[]{"ARRAY<DOUBLE>", DOUBLE_ARRAY, fancy}, (Object)new Object[]{"ARRAY<STRING>", STRING_ARRAY, IndexSpec.DEFAULT}, (Object)new Object[]{"ARRAY<STRING>", STRING_ARRAY, fancy}, (Object)new Object[]{"DOUBLE,LONG", VARIANT_NUMERIC, IndexSpec.DEFAULT}, (Object)new Object[]{"DOUBLE,LONG", VARIANT_NUMERIC, fancy}, (Object)new Object[]{"DOUBLE,LONG,STRING", VARIANT_SCALAR, IndexSpec.DEFAULT}, (Object)new Object[]{"DOUBLE,LONG,STRING", VARIANT_SCALAR, fancy}, (Object)new Object[]{"ARRAY<LONG>,ARRAY<STRING>,DOUBLE,LONG,STRING", VARIANT_SCALAR_AND_ARRAY, IndexSpec.DEFAULT}, (Object)new Object[]{"ARRAY<LONG>,ARRAY<STRING>,DOUBLE,LONG,STRING", VARIANT_SCALAR_AND_ARRAY, fancy}, (Object[])new Object[][]{{"ARRAY<DOUBLE>,ARRAY<LONG>,ARRAY<STRING>", VARIANT_ARRAY, IndexSpec.DEFAULT}, {"ARRAY<DOUBLE>,ARRAY<LONG>,ARRAY<STRING>", VARIANT_ARRAY, fancy}, {"ARRAY<LONG>", NO_TYPE_ARRAY, IndexSpec.DEFAULT}, {"ARRAY<LONG>", NO_TYPE_ARRAY, fancy}});
        return constructors;
    }

    public VariantColumnSupplierTest(String name, List<?> data, IndexSpec indexSpec) {
        this.data = data;
        this.indexSpec = indexSpec;
    }

    @Before
    public void setup() throws IOException {
        String fileNameBase = "test";
        this.fileMapper = this.smooshify("test", this.tempFolder.newFolder());
        this.baseBuffer = this.fileMapper.mapFile("test");
    }

    private SmooshedFileMapper smooshify(String fileNameBase, File tmpFile) throws IOException {
        TmpFileSegmentWriteOutMediumFactory writeOutMediumFactory = TmpFileSegmentWriteOutMediumFactory.instance();
        try (FileSmoosher smoosher = new FileSmoosher(tmpFile);){
            AutoTypeColumnIndexer indexer = new AutoTypeColumnIndexer("test", null);
            for (Object o : this.data) {
                indexer.processRowValsToUnsortedEncodedKeyComponent(o, false);
            }
            TreeMap sortedFields = new TreeMap();
            IndexableAdapter.NestedColumnMergable mergable = (IndexableAdapter.NestedColumnMergable)this.closer.register((Closeable)new IndexableAdapter.NestedColumnMergable(indexer.getSortedValueLookups(), indexer.getFieldTypeInfo(), false, false, null));
            SortedValueDictionary globalDictionarySortedCollector = mergable.getValueDictionary();
            mergable.mergeFieldsInto(sortedFields);
            this.expectedTypes = new FieldTypeInfo.MutableTypeSet((byte)(((FieldTypeInfo.MutableTypeSet)sortedFields.get("$")).getByteValue() & 0x7F));
            for (ColumnType type : FieldTypeInfo.convertToSet((byte)this.expectedTypes.getByteValue())) {
                this.expectedLogicalType = ColumnType.leastRestrictiveType((ColumnType)this.expectedLogicalType, (ColumnType)type);
            }
            if (this.expectedLogicalType == null && ((FieldTypeInfo.MutableTypeSet)sortedFields.get("$")).hasUntypedArray()) {
                this.expectedLogicalType = ColumnType.LONG_ARRAY;
            }
            VariantColumnSerializer serializer = new VariantColumnSerializer(fileNameBase, this.expectedTypes.getSingleType() == null ? null : this.expectedLogicalType, this.expectedTypes.getSingleType() == null ? Byte.valueOf(this.expectedTypes.getByteValue()) : null, this.indexSpec, writeOutMediumFactory.makeSegmentWriteOutMedium(this.tempFolder.newFolder()), this.closer);
            serializer.openDictionaryWriter();
            serializer.serializeDictionaries((Iterable)globalDictionarySortedCollector.getSortedStrings(), (Iterable)globalDictionarySortedCollector.getSortedLongs(), (Iterable)globalDictionarySortedCollector.getSortedDoubles(), () -> new AutoTypeColumnMerger.ArrayDictionaryMergingIterator(new Iterable[]{globalDictionarySortedCollector.getSortedArrays()}, serializer.getGlobalLookup()));
            serializer.open();
            NestedDataColumnSupplierTest.SettableSelector valueSelector = new NestedDataColumnSupplierTest.SettableSelector();
            for (Object o : this.data) {
                valueSelector.setObject(StructuredData.wrap(o));
                serializer.serialize((ColumnValueSelector)valueSelector);
            }
            try (SmooshedWriter writer = smoosher.addWithSmooshedWriter(fileNameBase, serializer.getSerializedSize());){
                serializer.writeTo((WritableByteChannel)writer, smoosher);
            }
            smoosher.close();
            SmooshedFileMapper smooshedFileMapper = (SmooshedFileMapper)this.closer.register((Closeable)SmooshedFileMapper.load((File)tmpFile));
            return smooshedFileMapper;
        }
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicFunctionality() throws IOException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        VariantColumnAndIndexSupplier supplier = VariantColumnAndIndexSupplier.read((ColumnType)this.expectedLogicalType, (ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        try (VariantColumn column = (VariantColumn)supplier.get();){
            this.smokeTest(supplier, column, this.data, this.expectedTypes);
        }
    }

    @Test
    public void testConcurrency() throws ExecutionException, InterruptedException {
        ColumnBuilder bob = new ColumnBuilder();
        bob.setFileMapper(this.fileMapper);
        VariantColumnAndIndexSupplier supplier = VariantColumnAndIndexSupplier.read((ColumnType)this.expectedLogicalType, (ByteOrder)ByteOrder.nativeOrder(), (BitmapSerdeFactory)this.bitmapSerdeFactory, (ByteBuffer)this.baseBuffer, (ColumnBuilder)bob, (ColumnConfig)NestedFieldColumnIndexSupplierTest.ALWAYS_USE_INDEXES);
        String expectedReason = "none";
        AtomicReference<String> failureReason = new AtomicReference<String>("none");
        int threads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)10, (String)"StandardNestedColumnSupplierTest-%d"));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        CountDownLatch threadsStartLatch = new CountDownLatch(1);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    threadsStartLatch.await();
                    for (int iter = 0; iter < 5000; ++iter) {
                        try (VariantColumn column = (VariantColumn)supplier.get();){
                            this.smokeTest(supplier, column, this.data, this.expectedTypes);
                            continue;
                        }
                    }
                }
                catch (Throwable ex) {
                    failureReason.set(ex.getMessage());
                }
            }));
        }
        threadsStartLatch.countDown();
        Futures.allAsList(futures).get();
        Assert.assertEquals((Object)"none", (Object)failureReason.get());
    }

    private void smokeTest(VariantColumnAndIndexSupplier supplier, VariantColumn<?> column, List<?> data, FieldTypeInfo.MutableTypeSet expectedType) {
        SimpleAscendingOffset offset = new SimpleAscendingOffset(data.size());
        NoFilterVectorOffset vectorOffset = new NoFilterVectorOffset(1, 0, data.size());
        ColumnValueSelector valueSelector = column.makeColumnValueSelector((ReadableOffset)offset);
        DimensionSelector dimensionSelector = this.expectedLogicalType.isPrimitive() ? column.makeDimensionSelector((ReadableOffset)offset, null) : null;
        VectorObjectSelector vectorObjectSelector = column.makeVectorObjectSelector((ReadableVectorOffset)vectorOffset);
        SingleValueDimensionVectorSelector dimensionVectorSelector = this.expectedLogicalType.isPrimitive() ? column.makeSingleValueDimensionVectorSelector((ReadableVectorOffset)vectorOffset) : null;
        StringValueSetIndexes valueSetIndex = (StringValueSetIndexes)supplier.as(StringValueSetIndexes.class);
        Assert.assertNull((Object)valueSetIndex);
        DruidPredicateIndexes predicateIndex = (DruidPredicateIndexes)supplier.as(DruidPredicateIndexes.class);
        Assert.assertNull((Object)predicateIndex);
        NullValueIndex nullValueIndex = (NullValueIndex)supplier.as(NullValueIndex.class);
        Assert.assertNotNull((Object)nullValueIndex);
        ValueIndexes valueIndexes = (ValueIndexes)supplier.as(ValueIndexes.class);
        ArrayElementIndexes arrayElementIndexes = (ArrayElementIndexes)supplier.as(ArrayElementIndexes.class);
        if (expectedType.getSingleType() != null && expectedType.getSingleType().isArray()) {
            Assert.assertNotNull((Object)valueIndexes);
            Assert.assertNotNull((Object)arrayElementIndexes);
        } else {
            Assert.assertNull((Object)valueIndexes);
            Assert.assertNull((Object)arrayElementIndexes);
        }
        SortedMap fields = column.getFieldTypeInfo();
        Assert.assertEquals((long)1L, (long)fields.size());
        Assert.assertEquals((Object)expectedType, fields.get("$"));
        ExpressionType expressionType = ExpressionType.fromColumnTypeStrict((TypeSignature)this.expectedLogicalType);
        for (int i = 0; i < data.size(); ++i) {
            Object row = data.get(i);
            if (row != null) {
                if (row instanceof List) {
                    Assert.assertArrayEquals((Object[])((List)row).toArray(), (Object[])((Object[])valueSelector.getObject()));
                    if (expectedType.getSingleType() != null) {
                        Assert.assertArrayEquals((Object[])((List)row).toArray(), (Object[])((Object[])vectorObjectSelector.getObjectVector()[0]));
                        Assert.assertTrue((boolean)((ImmutableBitmap)valueIndexes.forValue(row, (TypeSignature)expectedType.getSingleType()).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                        for (Object o : (List)row) {
                            Assert.assertTrue((String)("Failed on row: " + row), (boolean)((ImmutableBitmap)arrayElementIndexes.containsValue(o, expectedType.getSingleType().getElementType()).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                        }
                    } else {
                        Assert.assertArrayEquals((Object[])ExprEval.ofType((ExpressionType)expressionType, row).asArray(), (Object[])((Object[])vectorObjectSelector.getObjectVector()[0]));
                    }
                } else {
                    Assert.assertEquals(row, (Object)valueSelector.getObject());
                    if (expectedType.getSingleType() != null) {
                        Assert.assertEquals(row, (Object)vectorObjectSelector.getObjectVector()[0]);
                    } else {
                        ExprEval eval = ExprEval.ofType((ExpressionType)expressionType, row);
                        if (this.expectedLogicalType.isArray()) {
                            Assert.assertArrayEquals((Object[])eval.asArray(), (Object[])((Object[])vectorObjectSelector.getObjectVector()[0]));
                        } else {
                            Assert.assertEquals((Object)eval.value(), (Object)vectorObjectSelector.getObjectVector()[0]);
                        }
                    }
                    if (dimensionSelector != null) {
                        Assert.assertEquals((Object)String.valueOf(row), (Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
                        Assert.assertTrue((dimensionSelector.idLookup().lookupId(String.valueOf(row)) > 0 ? 1 : 0) != 0);
                        if (dimensionVectorSelector != null) {
                            int[] dim = dimensionVectorSelector.getRowVector();
                            Assert.assertEquals((Object)String.valueOf(row), (Object)dimensionVectorSelector.lookupName(dim[0]));
                        }
                    }
                }
                Assert.assertFalse((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
            } else {
                Assert.assertNull((Object)valueSelector.getObject());
                Assert.assertNull((Object)vectorObjectSelector.getObjectVector()[0]);
                if (dimensionSelector != null) {
                    Assert.assertNull((Object)dimensionSelector.lookupName(dimensionSelector.getRow().get(0)));
                    Assert.assertEquals((long)0L, (long)dimensionSelector.idLookup().lookupId(null));
                    if (dimensionVectorSelector != null) {
                        Assert.assertNull((Object)dimensionVectorSelector.lookupName(dimensionVectorSelector.getRowVector()[0]));
                    }
                }
                Assert.assertTrue((boolean)((ImmutableBitmap)nullValueIndex.get().computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                if (expectedType.getSingleType() != null) {
                    Assert.assertFalse((boolean)((ImmutableBitmap)arrayElementIndexes.containsValue(null, (TypeSignature)expectedType.getSingleType()).computeBitmapResult((BitmapResultFactory)this.resultFactory, false)).get(i));
                }
            }
            offset.increment();
            vectorOffset.advance();
        }
    }
}

