/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.ExpressionProcessing;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class TransformSpecTest
extends InitializedNullHandlingTest {
    private static final MapInputRowParser PARSER = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("t", "auto", DateTimes.of((String)"2000-01-01")), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"f", (Object)"x", (Object)"y")))));
    private static final Map<String, Object> ROW1 = ImmutableMap.builder().put((Object)"x", (Object)"foo").put((Object)"y", (Object)"bar").put((Object)"a", (Object)2.0).put((Object)"b", (Object)3L).put((Object)"bool", (Object)true).build();
    private static final Map<String, Object> ROW2 = ImmutableMap.builder().put((Object)"x", (Object)"foo").put((Object)"y", (Object)"baz").put((Object)"a", (Object)2.0).put((Object)"b", (Object)4L).put((Object)"bool", (Object)false).build();

    @Test
    public void testTransforms() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("f", "concat(x,y)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("g", "a + b", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("h", "concat(f,g)", TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y", (Object)"a", (Object)"b", (Object)"f", (Object)"g", (Object[])new String[0]), (Object)transformSpec.getRequiredColumns());
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)row.getTimestampFromEpoch());
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"f", (Object)"x", (Object)"y"), (Object)row.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"foo"), (Object)row.getDimension("x"));
        Assert.assertEquals((double)3.0, (double)row.getMetric("b").doubleValue(), (double)0.0);
        Assert.assertEquals((Object)"foobar", (Object)row.getRaw("f"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"foobar"), (Object)row.getDimension("f"));
        Assert.assertEquals((Object)ImmutableList.of((Object)"5.0"), (Object)row.getDimension("g"));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)row.getDimension("h"));
        Assert.assertEquals((long)5L, (long)row.getMetric("g").longValue());
    }

    @Test
    public void testTransformOverwriteField() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("x", "concat(x,y)", TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y"), (Object)transformSpec.getRequiredColumns());
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01").getMillis(), (long)row.getTimestampFromEpoch());
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01"), (Object)row.getTimestamp());
        Assert.assertEquals((Object)ImmutableList.of((Object)"f", (Object)"x", (Object)"y"), (Object)row.getDimensions());
        Assert.assertEquals((Object)ImmutableList.of((Object)"foobar"), (Object)row.getDimension("x"));
        Assert.assertEquals((double)3.0, (double)row.getMetric("b").doubleValue(), (double)0.0);
        Assert.assertNull((Object)row.getRaw("f"));
    }

    @Test
    public void testFilterOnTransforms() {
        TransformSpec transformSpec = new TransformSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("x", "foo", null), (Object)new SelectorDimFilter("f", "foobar", null), (Object)new SelectorDimFilter("g", "5.0", null))), (List)ImmutableList.of((Object)new ExpressionTransform("f", "concat(x,y)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("g", "a + b", TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"f", (Object)"g", (Object)"y", (Object)"a", (Object)"b", (Object[])new String[0]), (Object)transformSpec.getRequiredColumns());
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        Assert.assertNotNull(parser.parseBatch(ROW1).get(0));
        Assert.assertNull(parser.parseBatch(ROW2).get(0));
    }

    @Test
    public void testTransformTimeFromOtherFields() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "(a + b) * 3600000", TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"a", (Object)"b"), (Object)transformSpec.getRequiredColumns());
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)DateTimes.of((String)"1970-01-01T05:00:00Z"), (Object)row.getTimestamp());
        Assert.assertEquals((long)DateTimes.of((String)"1970-01-01T05:00:00Z").getMillis(), (long)row.getTimestampFromEpoch());
    }

    @Test
    public void testTransformTimeFromTime() {
        TransformSpec transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("__time", "__time + 3600000", TestExprMacroTable.INSTANCE)));
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time"), (Object)transformSpec.getRequiredColumns());
        InputRowParser parser = transformSpec.decorate((InputRowParser)PARSER);
        InputRow row = (InputRow)parser.parseBatch(ROW1).get(0);
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)DateTimes.of((String)"2000-01-01T01:00:00Z"), (Object)row.getTimestamp());
        Assert.assertEquals((long)DateTimes.of((String)"2000-01-01T01:00:00Z").getMillis(), (long)row.getTimestampFromEpoch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBoolTransforms() {
        InputRow row2;
        InputRow row;
        InputRowParser parser;
        TransformSpec transformSpec;
        try {
            ExpressionProcessing.initializeForStrictBooleansTests((boolean)true);
            transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("truthy1", "bool", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("truthy2", "if(bool,1,0)", TestExprMacroTable.INSTANCE)));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"bool"), (Object)transformSpec.getRequiredColumns());
            parser = transformSpec.decorate((InputRowParser)PARSER);
            row = (InputRow)parser.parseBatch(ROW1).get(0);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((Object)1L, (Object)row.getRaw("truthy1"));
            Assert.assertEquals((Object)1L, (Object)row.getRaw("truthy2"));
            row2 = (InputRow)parser.parseBatch(ROW2).get(0);
            Assert.assertNotNull((Object)row2);
            Assert.assertEquals((Object)0L, (Object)row2.getRaw("truthy1"));
            Assert.assertEquals((Object)0L, (Object)row2.getRaw("truthy2"));
        }
        finally {
            ExpressionProcessing.initializeForTests();
        }
        try {
            ExpressionProcessing.initializeForStrictBooleansTests((boolean)false);
            transformSpec = new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("truthy1", "bool", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("truthy2", "if(bool,1,0)", TestExprMacroTable.INSTANCE)));
            Assert.assertEquals((Object)ImmutableSet.of((Object)"bool"), (Object)transformSpec.getRequiredColumns());
            parser = transformSpec.decorate((InputRowParser)PARSER);
            row = (InputRow)parser.parseBatch(ROW1).get(0);
            Assert.assertNotNull((Object)row);
            Assert.assertEquals((Object)"true", (Object)row.getRaw("truthy1"));
            Assert.assertEquals((Object)1L, (Object)row.getRaw("truthy2"));
            row2 = (InputRow)parser.parseBatch(ROW2).get(0);
            Assert.assertNotNull((Object)row2);
            Assert.assertEquals((Object)"false", (Object)row2.getRaw("truthy1"));
            Assert.assertEquals((Object)0L, (Object)row2.getRaw("truthy2"));
        }
        finally {
            ExpressionProcessing.initializeForTests();
        }
    }

    @Test
    public void testSerde() throws Exception {
        TransformSpec transformSpec = new TransformSpec((DimFilter)new AndDimFilter((List)ImmutableList.of((Object)new SelectorDimFilter("x", "foo", null), (Object)new SelectorDimFilter("f", "foobar", null), (Object)new SelectorDimFilter("g", "5.0", null))), (List)ImmutableList.of((Object)new ExpressionTransform("f", "concat(x,y)", TestExprMacroTable.INSTANCE), (Object)new ExpressionTransform("g", "a + b", TestExprMacroTable.INSTANCE)));
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        Assert.assertEquals((Object)transformSpec, (Object)jsonMapper.readValue(jsonMapper.writeValueAsString((Object)transformSpec), TransformSpec.class));
    }
}

