/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.vector.BitmapVectorOffset;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.VectorOffset;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class NilVectorSelectorTest
extends InitializedNullHandlingTest {
    private static final int NUM_ROWS = 10000;

    @Test
    public void testDefaultSizedVector() {
        NilVectorSelectorTest.testVectorSize(512);
    }

    @Test
    public void testCustomSizeVector() {
        NilVectorSelectorTest.testVectorSize(1024);
    }

    private static void testVectorSize(int vectorSize) {
        NoFilterVectorOffset offset = new NoFilterVectorOffset(vectorSize, 0, 10000);
        NilVectorSelectorTest.testOffset((VectorOffset)offset);
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        int numSet = 0;
        for (int i = 0; i < 10000; ++i) {
            if (!(ThreadLocalRandom.current().nextDouble() > 0.2)) continue;
            bitmap.add(i);
            ++numSet;
        }
        BitmapVectorOffset bitmapOffset = new BitmapVectorOffset(vectorSize, bitmap.toImmutableBitmap(), 0, 10000);
        NilVectorSelectorTest.testOffset((VectorOffset)bitmapOffset);
    }

    private static void testOffset(VectorOffset offset) {
        NilVectorSelector nil = NilVectorSelector.create((VectorSizeInspector)offset);
        while (!offset.isDone()) {
            int[] dict = nil.getRowVector();
            long[] longs = nil.getLongVector();
            double[] doubles = nil.getDoubleVector();
            float[] floats = nil.getFloatVector();
            boolean[] nulls = nil.getNullVector();
            Object[] objects = nil.getObjectVector();
            for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                Assert.assertEquals((long)0L, (long)dict[i]);
                Assert.assertEquals((long)0L, (long)longs[i]);
                Assert.assertEquals((double)0.0, (double)doubles[i], (double)0.0);
                Assert.assertEquals((double)0.0, (double)floats[i], (double)0.0);
                Assert.assertEquals((Object)NullHandling.sqlCompatible(), (Object)nulls[i]);
                Assert.assertNull((Object)objects[i]);
            }
            offset.advance();
        }
    }
}

