/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.local;

import com.fasterxml.jackson.databind.InjectableValues;
import java.io.File;
import java.io.IOException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.storage.ExportStorageProvider;
import org.apache.druid.storage.StorageConfig;
import org.apache.druid.storage.StorageConnectorModule;
import org.apache.druid.storage.local.LocalFileExportStorageProvider;
import org.junit.Assert;
import org.junit.Test;

public class LocalFileExportStorageProviderTest {
    @Test
    public void testSerde() throws IOException {
        LocalFileExportStorageProvider exportDestination = new LocalFileExportStorageProvider("/basepath/export");
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        objectMapper.registerModules((Iterable)new StorageConnectorModule().getJacksonModules());
        objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(StorageConfig.class, (Object)new StorageConfig("/")));
        byte[] bytes = objectMapper.writeValueAsBytes((Object)exportDestination);
        ExportStorageProvider deserialized = (ExportStorageProvider)objectMapper.readValue(bytes, LocalFileExportStorageProvider.class);
        Assert.assertEquals((Object)exportDestination, (Object)deserialized);
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(LocalFileExportStorageProvider.class).withNonnullFields(new String[]{"exportPath"}).withIgnoredFields(new String[]{"storageConfig"}).usingGetClass().verify();
    }

    @Test
    public void testEmptyPath() {
        Assert.assertThrows(DruidException.class, () -> LocalFileExportStorageProvider.validateAndGetPath(null, (String)"path"));
    }

    @Test
    public void testValidate() {
        File file = LocalFileExportStorageProvider.validateAndGetPath((String)"/base", (String)"/base/path");
        Assert.assertEquals((Object)"/base/path", (Object)file.toPath().toString());
    }

    @Test
    public void testWithNonSubdir() {
        Assert.assertThrows(DruidException.class, () -> LocalFileExportStorageProvider.validateAndGetPath((String)"/base", (String)"/base/../path"));
        Assert.assertThrows(DruidException.class, () -> LocalFileExportStorageProvider.validateAndGetPath((String)"/base", (String)"/base1"));
    }
}

