/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableNode;
import org.apache.druid.collections.spatial.Node;
import org.apache.druid.collections.spatial.RTree;
import org.apache.druid.collections.spatial.search.Bound;
import org.apache.druid.collections.spatial.search.GutmanSearchStrategy;
import org.apache.druid.collections.spatial.search.SearchStrategy;
import org.apache.druid.io.Channels;
import org.apache.druid.segment.writeout.WriteOutBytes;

public final class ImmutableRTree
implements Comparable<ImmutableRTree> {
    private static final byte VERSION = 0;
    private static final ImmutableRTree EMPTY = new ImmutableRTree();
    private final int numDims;
    private final ImmutableNode root;
    private final ByteBuffer data;
    private final SearchStrategy defaultSearchStrategy = new GutmanSearchStrategy();

    public static ImmutableRTree empty() {
        return EMPTY;
    }

    private ImmutableRTree() {
        this.numDims = 0;
        this.data = ByteBuffer.wrap(ByteArrays.EMPTY_ARRAY);
        this.root = null;
    }

    public ImmutableRTree(ByteBuffer data, BitmapFactory bitmapFactory) {
        int initPosition = data.position();
        Preconditions.checkArgument((data.get(initPosition) == 0 ? 1 : 0) != 0, (Object)"Mismatching versions");
        this.numDims = data.getInt(1 + initPosition) & Short.MAX_VALUE;
        this.data = data;
        this.root = new ImmutableNode(this.numDims, initPosition, 5, data, bitmapFactory);
    }

    public static ImmutableRTree newImmutableFromMutable(RTree rTree) {
        if (rTree.getSize() == 0) {
            return ImmutableRTree.empty();
        }
        ByteBuffer buffer = ByteBuffer.allocate(ImmutableRTree.calcNumBytes(rTree));
        buffer.put((byte)0);
        buffer.putInt(rTree.getNumDims());
        rTree.getRoot().storeInByteBuffer(buffer, buffer.position());
        buffer.position(0);
        return new ImmutableRTree(buffer, rTree.getBitmapFactory());
    }

    private static int calcNumBytes(RTree tree) {
        int total = 5;
        return total += ImmutableRTree.calcNodeBytes(tree.getRoot());
    }

    private static int calcNodeBytes(Node node) {
        int total = 0;
        total += node.getSizeInBytes();
        for (Node child : node.getChildren()) {
            if (node.isLeaf()) {
                total += child.getSizeInBytes();
                continue;
            }
            total += ImmutableRTree.calcNodeBytes(child);
        }
        return total;
    }

    public int size() {
        return this.data.remaining();
    }

    public Iterable<ImmutableBitmap> search(Bound bound) {
        return this.search(this.defaultSearchStrategy, bound);
    }

    public Iterable<ImmutableBitmap> search(SearchStrategy strategy, Bound bound) {
        if (bound.getNumDims() == this.numDims) {
            return strategy.search(this.root, bound);
        }
        return ImmutableList.of();
    }

    public byte[] toBytes() {
        if (this.size() == 0) {
            return ByteArrays.EMPTY_ARRAY;
        }
        byte[] res = new byte[this.data.remaining()];
        this.data.duplicate().get(res);
        return res;
    }

    public void writeTo(WriteOutBytes out) throws IOException {
        if (this.size() != 0) {
            Channels.writeFully(out, this.data.duplicate());
        }
    }

    @Override
    public int compareTo(ImmutableRTree other) {
        return this.data.compareTo(other.data);
    }

    public boolean equals(Object obj) {
        return obj instanceof ImmutableRTree && this.data.equals(((ImmutableRTree)obj).data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

