/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class NullValueHandlingConfig {
    private static final Logger LOG = new Logger(NullValueHandlingConfig.class);
    public static final String NULL_HANDLING_CONFIG_STRING = "druid.generic.useDefaultValueForNull";
    public static final String THREE_VALUE_LOGIC_CONFIG_STRING = "druid.generic.useThreeValueLogicForNativeFilters";
    public static final String NULL_HANDLING_DURING_STRING_CARDINALITY = "druid.generic.ignoreNullsForStringCardinality";
    @JsonProperty(value="useDefaultValueForNull")
    private final boolean useDefaultValuesForNull;
    @JsonProperty(value="useThreeValueLogicForNativeFilters")
    private final boolean useThreeValueLogicForNativeFilters;
    @JsonProperty(value="ignoreNullsForStringCardinality")
    private final boolean ignoreNullsForStringCardinality;

    @JsonCreator
    public NullValueHandlingConfig(@JsonProperty(value="useDefaultValueForNull") Boolean useDefaultValuesForNull, @JsonProperty(value="useThreeValueLogicForNativeFilters") Boolean useThreeValueLogicForNativeFilters, @JsonProperty(value="ignoreNullsForStringCardinality") Boolean ignoreNullsForStringCardinality) {
        this.useDefaultValuesForNull = useDefaultValuesForNull == null ? Boolean.valueOf(System.getProperty(NULL_HANDLING_CONFIG_STRING, "false")).booleanValue() : useDefaultValuesForNull.booleanValue();
        this.useThreeValueLogicForNativeFilters = useThreeValueLogicForNativeFilters == null ? Boolean.valueOf(System.getProperty(THREE_VALUE_LOGIC_CONFIG_STRING, "true")).booleanValue() : useThreeValueLogicForNativeFilters.booleanValue();
        this.ignoreNullsForStringCardinality = ignoreNullsForStringCardinality == null ? Boolean.valueOf(System.getProperty(NULL_HANDLING_DURING_STRING_CARDINALITY, "false")) : (this.useDefaultValuesForNull ? ignoreNullsForStringCardinality : false);
        String version = NullValueHandlingConfig.class.getPackage().getImplementationVersion();
        if (version == null || version.contains("SNAPSHOT")) {
            version = "latest";
        }
        String docsBaseFormat = "https://druid.apache.org/docs/%s/querying/sql-data-types#%s";
        if (this.useDefaultValuesForNull) {
            LOG.warn("druid.generic.useDefaultValueForNull set to 'true', we recommend using 'false' if using SQL to query Druid for the most SQL compliant behavior, see %s for details", StringUtils.format("https://druid.apache.org/docs/%s/querying/sql-data-types#%s", version, "null-values"));
        }
        if (!this.useThreeValueLogicForNativeFilters) {
            LOG.warn("druid.generic.useThreeValueLogic set to 'false', we recommend using 'true' if using SQL to query Druid for the most SQL compliant behavior, see %s for details", StringUtils.format("https://druid.apache.org/docs/%s/querying/sql-data-types#%s", version, "boolean-logic"));
        }
    }

    public boolean isIgnoreNullsForStringCardinality() {
        return this.ignoreNullsForStringCardinality;
    }

    public boolean isUseDefaultValuesForNull() {
        return this.useDefaultValuesForNull;
    }

    public boolean isUseThreeValueLogicForNativeFilters() {
        return this.useThreeValueLogicForNativeFilters;
    }
}

