/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.FastLineIterator;
import org.apache.druid.java.util.common.parsers.CloseableIteratorWithMetadata;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.ParserUtils;

public abstract class TextReader
extends IntermediateRowParsingReader<String> {
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;

    public TextReader(InputRowSchema inputRowSchema, InputEntity source) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
    }

    public InputRowSchema getInputRowSchema() {
        return this.inputRowSchema;
    }

    @Override
    public CloseableIteratorWithMetadata<String> intermediateRowIteratorWithMetadata() throws IOException {
        final FastLineIterator delegate = new FastLineIterator(this.source.open());
        final int numHeaderLines = this.getNumHeaderLinesToSkip();
        for (int i = 0; i < numHeaderLines && delegate.hasNext(); ++i) {
            delegate.next();
        }
        if (this.needsToProcessHeaderLine() && delegate.hasNext()) {
            this.processHeaderLine((String)delegate.next());
        }
        return new CloseableIteratorWithMetadata<String>(){
            private static final String LINE_KEY = "Line";
            private long currentLineNumber;
            {
                this.currentLineNumber = numHeaderLines + (TextReader.this.needsToProcessHeaderLine() ? 1 : 0);
            }

            @Override
            public Map<String, Object> currentMetadata() {
                return Collections.singletonMap(LINE_KEY, this.currentLineNumber);
            }

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public String next() {
                ++this.currentLineNumber;
                return (String)delegate.next();
            }

            @Override
            public void close() throws IOException {
                delegate.close();
            }
        };
    }

    @Override
    protected InputEntity source() {
        return this.source;
    }

    @Override
    public abstract List<InputRow> parseInputRows(String var1) throws IOException, ParseException;

    public abstract int getNumHeaderLinesToSkip();

    public abstract boolean needsToProcessHeaderLine();

    public abstract void processHeaderLine(String var1) throws IOException;

    public static List<String> findOrCreateColumnNames(List<String> parsedLine) {
        ArrayList<String> columns = new ArrayList<String>(parsedLine.size());
        for (int i = 0; i < parsedLine.size(); ++i) {
            if (Strings.isNullOrEmpty((String)parsedLine.get(i))) {
                columns.add(ParserUtils.getDefaultColumnName(i));
                continue;
            }
            columns.add(parsedLine.get(i));
        }
        if (columns.isEmpty()) {
            return ParserUtils.generateFieldNames(parsedLine.size());
        }
        ParserUtils.validateFields(columns);
        return columns;
    }
}

