/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class CloudObjectLocation {
    private final String bucket;
    private final String path;

    public static URI validateUriScheme(String scheme, URI uri) {
        if (!scheme.equalsIgnoreCase(uri.getScheme())) {
            throw new IAE("Invalid URI scheme [%s] must be [%s]", uri.toString(), scheme);
        }
        return uri;
    }

    @JsonCreator
    public CloudObjectLocation(@JsonProperty(value="bucket") String bucket, @JsonProperty(value="path") String path) {
        this.bucket = (String)Preconditions.checkNotNull((Object)StringUtils.maybeRemoveTrailingSlash(bucket), (Object)"bucket name cannot be null. Please verify if bucket name adheres to naming rules");
        this.path = (String)Preconditions.checkNotNull((Object)StringUtils.maybeRemoveLeadingSlash(path));
        Preconditions.checkArgument((boolean)this.bucket.equals(StringUtils.urlEncode(this.bucket)), (Object)"bucket must follow DNS-compliant naming conventions");
    }

    public CloudObjectLocation(URI uri) {
        this(uri.getHost() != null ? uri.getHost() : uri.getAuthority(), uri.getPath());
    }

    public URI toUri(String scheme) {
        return URI.create(StringUtils.format("%s://%s/%s", scheme, this.bucket, StringUtils.replace(StringUtils.urlEncode(this.path), "%2F", "/")));
    }

    @JsonProperty
    public String getBucket() {
        return this.bucket;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "CloudObjectLocation{bucket='" + this.bucket + '\'' + ", path='" + this.path + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudObjectLocation that = (CloudObjectLocation)o;
        return Objects.equals(this.bucket, that.bucket) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.path);
    }
}

