/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.NestedDataParseSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.parsers.JSONPathParser;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.Parser;

public class JSONParseSpec
extends NestedDataParseSpec<JSONPathSpec> {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, Boolean> featureSpec;
    private final boolean keepNullColumns;

    @JsonCreator
    public JSONParseSpec(@JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") DimensionsSpec dimensionsSpec, @JsonProperty(value="flattenSpec") JSONPathSpec flattenSpec, @JsonProperty(value="featureSpec") Map<String, Boolean> featureSpec, @JsonProperty(value="keepNullColumns") Boolean keepNullColumns) {
        super(timestampSpec, dimensionsSpec, flattenSpec != null ? flattenSpec : JSONPathSpec.DEFAULT);
        this.keepNullColumns = keepNullColumns == null ? false : keepNullColumns;
        this.featureSpec = featureSpec == null ? new HashMap() : featureSpec;
        for (Map.Entry<String, Boolean> entry : this.featureSpec.entrySet()) {
            JsonParser.Feature feature = JsonParser.Feature.valueOf((String)entry.getKey());
            this.objectMapper.configure(feature, entry.getValue().booleanValue());
        }
    }

    public JSONParseSpec(TimestampSpec ts, DimensionsSpec dims) {
        this(ts, dims, null, null, false);
    }

    @Override
    public Parser<String, Object> makeParser() {
        return new JSONPathParser((JSONPathSpec)this.getFlattenSpec(), this.objectMapper, this.getKeepNullColumns());
    }

    @Override
    public ParseSpec withTimestampSpec(TimestampSpec spec) {
        return new JSONParseSpec(spec, this.getDimensionsSpec(), (JSONPathSpec)this.getFlattenSpec(), this.getFeatureSpec(), this.getKeepNullColumns());
    }

    @Override
    public ParseSpec withDimensionsSpec(DimensionsSpec spec) {
        return new JSONParseSpec(this.getTimestampSpec(), spec, (JSONPathSpec)this.getFlattenSpec(), this.getFeatureSpec(), this.getKeepNullColumns());
    }

    @JsonProperty
    public Map<String, Boolean> getFeatureSpec() {
        return this.featureSpec;
    }

    @JsonProperty
    public boolean getKeepNullColumns() {
        return this.keepNullColumns;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSONParseSpec that = (JSONParseSpec)o;
        return Objects.equals(this.featureSpec, that.featureSpec) && Objects.equals(this.keepNullColumns, that.keepNullColumns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.featureSpec, this.getKeepNullColumns());
    }

    public String toString() {
        return "JSONParseSpec{timestampSpec=" + this.getTimestampSpec() + ", dimensionsSpec=" + this.getDimensionsSpec() + ", flattenSpec=" + this.getFlattenSpec() + ", featureSpec=" + this.featureSpec + ", keepNullColumns=" + this.keepNullColumns + '}';
    }
}

