/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.JsonLineReader;
import org.apache.druid.data.input.impl.JsonNodeReader;
import org.apache.druid.data.input.impl.JsonReader;
import org.apache.druid.data.input.impl.NestedInputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.utils.CompressionUtils;

public class JsonInputFormat
extends NestedInputFormat {
    public static final String TYPE_KEY = "json";
    private final Map<String, Boolean> featureSpec;
    private final ObjectMapper objectMapper;
    private final boolean keepNullColumns;
    private final boolean lineSplittable;
    private final boolean assumeNewlineDelimited;
    private final boolean useJsonNodeReader;

    @JsonCreator
    public JsonInputFormat(@JsonProperty(value="flattenSpec") @Nullable JSONPathSpec flattenSpec, @JsonProperty(value="featureSpec") @Nullable Map<String, Boolean> featureSpec, @JsonProperty(value="keepNullColumns") @Nullable Boolean keepNullColumns, @JsonProperty(value="assumeNewlineDelimited") @Nullable Boolean assumeNewlineDelimited, @JsonProperty(value="useJsonNodeReader") @Nullable Boolean useJsonNodeReader) {
        this(flattenSpec, featureSpec, keepNullColumns, true, assumeNewlineDelimited, useJsonNodeReader);
    }

    public JsonInputFormat(@Nullable JSONPathSpec flattenSpec, Map<String, Boolean> featureSpec, Boolean keepNullColumns, boolean lineSplittable, Boolean assumeNewlineDelimited, Boolean useJsonNodeReader) {
        super(flattenSpec);
        this.featureSpec = featureSpec == null ? Collections.emptyMap() : featureSpec;
        this.objectMapper = new ObjectMapper();
        this.keepNullColumns = keepNullColumns != null ? keepNullColumns : flattenSpec != null && flattenSpec.isUseFieldDiscovery();
        for (Map.Entry<String, Boolean> entry : this.featureSpec.entrySet()) {
            JsonParser.Feature feature = JsonParser.Feature.valueOf((String)entry.getKey());
            this.objectMapper.configure(feature, entry.getValue().booleanValue());
        }
        this.lineSplittable = lineSplittable;
        this.assumeNewlineDelimited = assumeNewlineDelimited != null && assumeNewlineDelimited != false;
        boolean bl = this.useJsonNodeReader = useJsonNodeReader != null && useJsonNodeReader != false;
        if (this.assumeNewlineDelimited && this.useJsonNodeReader) {
            throw new IAE("useJsonNodeReader cannot be set to true when assumeNewlineDelimited is true.", new Object[0]);
        }
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Boolean> getFeatureSpec() {
        return this.featureSpec;
    }

    @JsonProperty
    public boolean isKeepNullColumns() {
        return this.keepNullColumns;
    }

    @JsonProperty
    public boolean isAssumeNewlineDelimited() {
        return this.assumeNewlineDelimited;
    }

    @JsonProperty
    public boolean isUseJsonNodeReader() {
        return this.useJsonNodeReader;
    }

    @Override
    public boolean isSplittable() {
        return false;
    }

    @Override
    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        if (this.lineSplittable || this.assumeNewlineDelimited) {
            return new JsonLineReader(inputRowSchema, source, this.getFlattenSpec(), this.objectMapper, this.keepNullColumns);
        }
        if (this.useJsonNodeReader) {
            return new JsonNodeReader(inputRowSchema, source, this.getFlattenSpec(), this.objectMapper, this.keepNullColumns);
        }
        return new JsonReader(inputRowSchema, source, this.getFlattenSpec(), this.objectMapper, this.keepNullColumns);
    }

    @Override
    public long getWeightedSize(String path, long size) {
        CompressionUtils.Format compressionFormat = CompressionUtils.Format.fromFileName(path);
        if (CompressionUtils.Format.GZ == compressionFormat) {
            return size * 4L;
        }
        return size;
    }

    public JsonInputFormat withLineSplittable(boolean lineSplittable) {
        return new JsonInputFormat(this.getFlattenSpec(), this.getFeatureSpec(), this.keepNullColumns, lineSplittable, this.assumeNewlineDelimited, this.useJsonNodeReader);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonInputFormat that = (JsonInputFormat)o;
        return this.keepNullColumns == that.keepNullColumns && this.lineSplittable == that.lineSplittable && this.assumeNewlineDelimited == that.assumeNewlineDelimited && this.useJsonNodeReader == that.useJsonNodeReader && Objects.equals(this.featureSpec, that.featureSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.featureSpec, this.keepNullColumns, this.lineSplittable, this.assumeNewlineDelimited, this.useJsonNodeReader);
    }

    public String toString() {
        return "JsonInputFormat{featureSpec=" + this.featureSpec + ", keepNullColumns=" + this.keepNullColumns + ", lineSplittable=" + this.lineSplittable + ", assumeNewlineDelimited=" + this.assumeNewlineDelimited + ", useJsonNodeReader=" + this.useJsonNodeReader + '}';
    }
}

