/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.CollectionUtils;

public class JsonReader
extends IntermediateRowParsingReader<String> {
    private final ObjectFlattener<JsonNode> flattener;
    private final ObjectMapper mapper;
    private final InputEntity source;
    private final InputRowSchema inputRowSchema;
    private final JsonFactory jsonFactory;

    JsonReader(InputRowSchema inputRowSchema, InputEntity source, JSONPathSpec flattenSpec, ObjectMapper mapper, boolean keepNullColumns) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker(keepNullColumns, inputRowSchema.getDimensionsSpec().useSchemaDiscovery()));
        this.mapper = mapper;
        this.jsonFactory = new JsonFactory();
    }

    @Override
    protected CloseableIterator<String> intermediateRowIterator() throws IOException {
        return CloseableIterators.withEmptyBaggage(Iterators.singletonIterator((Object)IOUtils.toString((InputStream)this.source.open(), (String)StringUtils.UTF8_STRING)));
    }

    @Override
    protected InputEntity source() {
        return this.source;
    }

    @Override
    protected List<InputRow> parseInputRows(String intermediateRow) throws IOException, ParseException {
        ImmutableList inputRows;
        try (JsonParser parser = this.jsonFactory.createParser(intermediateRow);){
            MappingIterator delegate = this.mapper.readValues(parser, JsonNode.class);
            inputRows = FluentIterable.from(() -> delegate).transform(jsonNode -> MapInputRowParser.parse(this.inputRowSchema, this.flattener.flatten((JsonNode)jsonNode))).toList();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof JsonParseException) {
                throw new ParseException(intermediateRow, (Throwable)e, "Unable to parse row [%s]", intermediateRow);
            }
            throw e;
        }
        if (CollectionUtils.isNullOrEmpty(inputRows)) {
            throw new ParseException(intermediateRow, "Unable to parse [%s] as the intermediateRow resulted in empty input row", intermediateRow);
        }
        return inputRows;
    }

    @Override
    protected List<Map<String, Object>> toMap(String intermediateRow) throws IOException {
        ImmutableList immutableList;
        block9: {
            JsonParser parser = this.jsonFactory.createParser(intermediateRow);
            try {
                MappingIterator delegate = this.mapper.readValues(parser, Map.class);
                immutableList = FluentIterable.from(() -> delegate).transform(map -> map).toList();
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof JsonParseException) {
                        throw new ParseException(intermediateRow, (Throwable)e, "Unable to parse row [%s]", intermediateRow);
                    }
                    throw e;
                }
            }
            parser.close();
        }
        return immutableList;
    }
}

