/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.Memory;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.frame.field.NumericFieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.column.ValueType;

public class DoubleFieldReader
extends NumericFieldReader {
    public static DoubleFieldReader forPrimitive() {
        return new DoubleFieldReader(false);
    }

    public static DoubleFieldReader forArray() {
        return new DoubleFieldReader(true);
    }

    private DoubleFieldReader(boolean forArray) {
        super(forArray);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.DOUBLE;
    }

    @Override
    public ColumnValueSelector<?> getColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
        return new DoubleFieldSelector(memory, fieldPointer, nullIndicatorByte);
    }

    private static class DoubleFieldSelector
    extends NumericFieldReader.Selector
    implements DoubleColumnSelector {
        final Memory dataRegion;
        final ReadableFieldPointer fieldPointer;

        public DoubleFieldSelector(Memory dataRegion, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
            super(dataRegion, fieldPointer, nullIndicatorByte);
            this.dataRegion = dataRegion;
            this.fieldPointer = fieldPointer;
        }

        @Override
        public double getDouble() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            long bits = this.dataRegion.getLong(this.fieldPointer.position() + 1L);
            return TransformUtils.detransformToDouble(bits);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public boolean isNull() {
            return super._isNull();
        }
    }
}

