/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;

public abstract class NumericFieldReader
implements FieldReader {
    private final byte nullIndicatorByte;

    public NumericFieldReader(boolean forArray) {
        this.nullIndicatorByte = !forArray ? (byte)0 : 1;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return this.getColumnValueSelector(memory, fieldPointer, this.nullIndicatorByte);
    }

    @Override
    public DimensionSelector makeDimensionSelector(Memory memory, ReadableFieldPointer fieldPointer, @Nullable ExtractionFn extractionFn) {
        return ValueTypes.makeNumericWrappingDimensionSelector(this.getValueType(), this.makeColumnValueSelector(memory, fieldPointer), extractionFn);
    }

    @Override
    public boolean isNull(Memory memory, long position) {
        return memory.getByte(position) == this.nullIndicatorByte;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    public abstract ColumnValueSelector<?> getColumnValueSelector(Memory var1, ReadableFieldPointer var2, byte var3);

    public abstract ValueType getValueType();

    public static abstract class Selector {
        private final Memory dataRegion;
        private final ReadableFieldPointer fieldPointer;
        private final byte nullIndicatorByte;

        public Selector(Memory dataRegion, ReadableFieldPointer fieldPointer, byte nullIndicatorByte) {
            this.dataRegion = dataRegion;
            this.fieldPointer = fieldPointer;
            this.nullIndicatorByte = nullIndicatorByte;
        }

        protected boolean _isNull() {
            return this.dataRegion.getByte(this.fieldPointer.position()) == this.nullIndicatorByte;
        }
    }
}

