/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.FieldWriter;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.segment.DimensionSelector;

public class StringFieldWriter
implements FieldWriter {
    public static final byte VALUE_TERMINATOR = 0;
    public static final byte ROW_TERMINATOR = 1;
    public static final byte NULL_ROW = 0;
    public static final byte NULL_BYTE = 2;
    public static final byte NOT_NULL_BYTE = 3;
    private static final int NONNULL_ROW_MINIMUM_SIZE = 3;
    private static final byte NULL_ROW_SIZE = 2;
    private final DimensionSelector selector;

    public StringFieldWriter(DimensionSelector selector) {
        this.selector = selector;
    }

    @Override
    public long writeTo(WritableMemory memory, long position, long maxSize) {
        List<ByteBuffer> byteBuffers = FrameWriterUtils.getUtf8ByteBuffersFromStringSelector(this.selector, true);
        return StringFieldWriter.writeUtf8ByteBuffers(memory, position, maxSize, byteBuffers);
    }

    @Override
    public void close() {
    }

    static long writeUtf8ByteBuffers(WritableMemory memory, long position, long maxSize, @Nullable List<ByteBuffer> byteBuffers) {
        if (byteBuffers == null) {
            if (maxSize < 2L) {
                return -1L;
            }
            memory.putByte(position, (byte)0);
            memory.putByte(position + 1L, (byte)1);
            return 2L;
        }
        long written = 0L;
        for (ByteBuffer utf8Datum : byteBuffers) {
            int len = utf8Datum.remaining();
            if (written + 3L > maxSize) {
                return -1L;
            }
            if (len == 1 && utf8Datum.get(utf8Datum.position()) == -1) {
                memory.putByte(position + written, (byte)2);
                ++written;
            } else {
                if (written + (long)len + 3L > maxSize) {
                    return -1L;
                }
                memory.putByte(position + written, (byte)3);
                ++written;
                if (len > 0) {
                    FrameWriterUtils.copyByteBufferToMemory(utf8Datum, memory, position + written, len, false);
                    written += (long)len;
                }
            }
            memory.putByte(position + written, (byte)0);
            ++written;
        }
        if (written + 1L > maxSize) {
            return -1L;
        }
        memory.putByte(position + written, (byte)1);
        return ++written;
    }
}

