/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.primitives.Ints;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.key.ByteRowKeyComparator;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.key.RowKeyReader;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.RowSignature;

public class FrameComparisonWidgetImpl
implements FrameComparisonWidget {
    private final Frame frame;
    private final RowSignature signature;
    private final Memory rowOffsetRegion;
    private final Memory dataRegion;
    private final int keyFieldCount;
    private final List<FieldReader> keyFieldReaders;
    private final int firstFieldPosition;
    private final int[] ascDescRunLengths;

    private FrameComparisonWidgetImpl(Frame frame, RowSignature signature, Memory rowOffsetRegion, Memory dataRegion, List<FieldReader> keyFieldReaders, int firstFieldPosition, int[] ascDescRunLengths) {
        this.frame = frame;
        this.signature = signature;
        this.rowOffsetRegion = rowOffsetRegion;
        this.dataRegion = dataRegion;
        this.keyFieldCount = keyFieldReaders.size();
        this.keyFieldReaders = keyFieldReaders;
        this.firstFieldPosition = firstFieldPosition;
        this.ascDescRunLengths = ascDescRunLengths;
    }

    public static FrameComparisonWidgetImpl create(Frame frame, RowSignature signature, List<KeyColumn> keyColumns, List<FieldReader> keyColumnReaders) {
        FrameWriterUtils.verifySortColumns(keyColumns, signature);
        if (keyColumnReaders.size() != keyColumns.size()) {
            throw new ISE("Mismatched lengths for keyColumnReaders and keyColumns", new Object[0]);
        }
        return new FrameComparisonWidgetImpl(FrameType.ROW_BASED.ensureType(frame), signature, frame.region(0), frame.region(1), keyColumnReaders, ByteRowKeyComparator.computeFirstFieldPosition(signature.size()), ByteRowKeyComparator.computeAscDescRunLengths(keyColumns));
    }

    @Override
    public RowKey readKey(int row) {
        int i;
        if (this.keyFieldCount == 0) {
            return RowKey.empty();
        }
        int keyFieldPointersEndInRow = this.keyFieldCount * 4;
        long rowPosition = this.getRowPositionInDataRegion(row);
        int keyEndInRow = this.dataRegion.getInt(rowPosition + (long)(this.keyFieldCount - 1) * 4L);
        long keyLength = keyEndInRow - this.firstFieldPosition;
        byte[] keyBytes = new byte[Ints.checkedCast((long)(keyFieldPointersEndInRow + keyEndInRow - this.firstFieldPosition))];
        int headerSizeAdjustment = (this.signature.size() - this.keyFieldCount) * 4;
        for (i = 0; i < this.keyFieldCount; ++i) {
            int fieldEndPosition = this.dataRegion.getInt(rowPosition + 4L * (long)i);
            int adjustedFieldEndPosition = fieldEndPosition - headerSizeAdjustment;
            keyBytes[4 * i] = (byte)adjustedFieldEndPosition;
            keyBytes[4 * i + 1] = (byte)(adjustedFieldEndPosition >> 8);
            keyBytes[4 * i + 2] = (byte)(adjustedFieldEndPosition >> 16);
            keyBytes[4 * i + 3] = (byte)(adjustedFieldEndPosition >> 24);
        }
        i = 0;
        while ((long)i < keyLength) {
            keyBytes[keyFieldPointersEndInRow + i] = this.dataRegion.getByte(rowPosition + (long)this.firstFieldPosition + (long)i);
            ++i;
        }
        return RowKey.wrap(keyBytes);
    }

    @Override
    public boolean isCompletelyNonNullKey(int row) {
        if (this.keyFieldCount == 0) {
            return true;
        }
        long rowPosition = this.getRowPositionInDataRegion(row);
        long keyFieldPosition = rowPosition + (long)this.signature.size() * 4L;
        for (int i = 0; i < this.keyFieldCount; ++i) {
            boolean isNull = this.keyFieldReaders.get(i).isNull(this.dataRegion, keyFieldPosition);
            if (isNull) {
                return false;
            }
            keyFieldPosition = rowPosition + (long)this.dataRegion.getInt(rowPosition + (long)i * 4L);
        }
        return true;
    }

    @Override
    public int compare(int row, RowKey key) {
        byte[] keyArray = key.array();
        long rowPosition = this.getRowPositionInDataRegion(row);
        long comparableBytesStartPositionInRow = this.firstFieldPosition;
        int keyComparableBytesStartPosition = 4 * this.keyFieldCount;
        boolean ascending = true;
        int field = 0;
        for (int numFields : this.ascDescRunLengths) {
            if (numFields > 0) {
                int keyComparableBytesEndPosition;
                int keyComparableBytesLength;
                int nextField = field + numFields;
                long comparableBytesEndPositionInRow = this.getFieldEndPositionInRow(rowPosition, nextField - 1);
                long comparableBytesLength = comparableBytesEndPositionInRow - comparableBytesStartPositionInRow;
                int cmp = FrameReaderUtils.compareMemoryToByteArrayUnsigned(this.dataRegion, rowPosition + comparableBytesStartPositionInRow, comparableBytesLength, keyArray, keyComparableBytesStartPosition, keyComparableBytesLength = (keyComparableBytesEndPosition = RowKeyReader.fieldEndPosition(keyArray, nextField - 1)) - keyComparableBytesStartPosition);
                if (cmp != 0) {
                    return ascending ? cmp : -cmp;
                }
                field += numFields;
                comparableBytesStartPositionInRow += comparableBytesLength;
                keyComparableBytesStartPosition += keyComparableBytesLength;
            }
            ascending = !ascending;
        }
        return 0;
    }

    @Override
    public int compare(int row, FrameComparisonWidget otherWidget, int otherRow) {
        FrameComparisonWidgetImpl otherWidgetImpl = (FrameComparisonWidgetImpl)otherWidget;
        long rowPosition = this.getRowPositionInDataRegion(row);
        long otherRowPosition = otherWidgetImpl.getRowPositionInDataRegion(otherRow);
        int comparableBytesStartPositionInRow = this.firstFieldPosition;
        int otherComparableBytesStartPositionInRow = otherWidgetImpl.firstFieldPosition;
        boolean ascending = true;
        int field = 0;
        for (int numFields : this.ascDescRunLengths) {
            if (numFields > 0) {
                int nextField = field + numFields;
                int comparableBytesEndPositionInRow = this.getFieldEndPositionInRow(rowPosition, nextField - 1);
                int otherComparableBytesEndPositionInRow = otherWidgetImpl.getFieldEndPositionInRow(otherRowPosition, nextField - 1);
                int comparableBytesLength = comparableBytesEndPositionInRow - comparableBytesStartPositionInRow;
                int otherComparableBytesLength = otherComparableBytesEndPositionInRow - otherComparableBytesStartPositionInRow;
                int cmp = FrameReaderUtils.compareMemoryUnsigned(this.dataRegion, rowPosition + (long)comparableBytesStartPositionInRow, comparableBytesLength, otherWidgetImpl.getDataRegion(), otherRowPosition + (long)otherComparableBytesStartPositionInRow, otherComparableBytesLength);
                if (cmp != 0) {
                    return ascending ? cmp : -cmp;
                }
                field += numFields;
                comparableBytesStartPositionInRow += comparableBytesLength;
                otherComparableBytesStartPositionInRow += otherComparableBytesLength;
            }
            ascending = !ascending;
        }
        return 0;
    }

    long getRowPositionInDataRegion(int logicalRow) {
        int physicalRowNumber = this.frame.physicalRow(logicalRow);
        if (physicalRowNumber == 0) {
            return 0L;
        }
        return this.rowOffsetRegion.getLong(8L * (long)(physicalRowNumber - 1));
    }

    int getFieldEndPositionInRow(long rowPosition, int fieldNumber) {
        assert (fieldNumber >= 0 && fieldNumber < this.signature.size());
        return this.dataRegion.getInt(rowPosition + (long)fieldNumber * 4L);
    }

    Memory getDataRegion() {
        return this.dataRegion;
    }
}

