/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.segment.FrameStorageAdapter;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.VirtualColumns;

public class FrameProcessors {
    private FrameProcessors() {
    }

    public static <T> FrameProcessor<T> withBaggage(final FrameProcessor<T> processor, final Closeable baggage) {
        class FrameProcessorWithBaggage
        implements FrameProcessor<T> {
            final AtomicBoolean cleanedUp = new AtomicBoolean();

            FrameProcessorWithBaggage() {
            }

            @Override
            public List<ReadableFrameChannel> inputChannels() {
                return processor.inputChannels();
            }

            @Override
            public List<WritableFrameChannel> outputChannels() {
                return processor.outputChannels();
            }

            @Override
            public ReturnOrAwait<T> runIncrementally(IntSet readableInputs) throws InterruptedException, IOException {
                return processor.runIncrementally(readableInputs);
            }

            @Override
            public void cleanup() throws IOException {
                if (this.cleanedUp.compareAndSet(false, true)) {
                    try (Closeable ignore1 = baggage;){
                        Closeable ignore2 = processor::cleanup;
                        if (ignore2 != null) {
                            ignore2.close();
                        }
                    }
                }
            }

            public String toString() {
                return processor + " (with baggage)";
            }
        }
        return new FrameProcessorWithBaggage();
    }

    public static FrameCursor makeCursor(Frame frame, FrameReader frameReader) {
        return FrameProcessors.makeCursor(frame, frameReader, VirtualColumns.EMPTY);
    }

    public static FrameCursor makeCursor(Frame frame, FrameReader frameReader, VirtualColumns virtualColumns) {
        return (FrameCursor)Yielders.each(new FrameStorageAdapter(frame, frameReader, Intervals.ETERNITY).makeCursors(null, Intervals.ETERNITY, virtualColumns, Granularities.ALL, false, null)).get();
    }

    public static IntSortedSet rangeSet(int size) {
        if (size < 0) {
            throw new IAE("Size must be nonnegative", new Object[0]);
        }
        IntAVLTreeSet set = new IntAVLTreeSet();
        for (int i = 0; i < size; ++i) {
            set.add(i);
        }
        return set;
    }

    public static int selectRandom(IntSet ints) {
        int idx = ThreadLocalRandom.current().nextInt(ints.size());
        IntIterator iterator = ints.iterator();
        iterator.skip(idx);
        return iterator.nextInt();
    }

    public static void closeAll(List<ReadableFrameChannel> readableFrameChannels, List<WritableFrameChannel> writableFrameChannels, Closeable ... otherCloseables) throws IOException {
        Closer closer = Closer.create();
        for (Closeable closeable : Lists.reverse(Arrays.asList(otherCloseables))) {
            if (closeable == null) continue;
            closer.register(closeable);
        }
        for (Closeable channel : Lists.reverse(writableFrameChannels)) {
            closer.register(channel);
        }
        for (Closeable channel : Lists.reverse(readableFrameChannels)) {
            closer.register(channel);
        }
        closer.close();
    }
}

