/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameStorageAdapter;
import org.apache.druid.query.rowsandcols.concrete.FrameRowsAndColumns;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class FrameSegment
implements Segment {
    private final Frame frame;
    private final FrameReader frameReader;
    private final SegmentId segmentId;

    public FrameSegment(Frame frame, FrameReader frameReader, SegmentId segmentId) {
        this.frame = frame;
        this.frameReader = frameReader;
        this.segmentId = segmentId;
    }

    @Override
    public SegmentId getId() {
        return this.segmentId;
    }

    @Override
    public Interval getDataInterval() {
        return this.segmentId.getInterval();
    }

    @Override
    @Nullable
    public QueryableIndex asQueryableIndex() {
        return null;
    }

    @Override
    public StorageAdapter asStorageAdapter() {
        return new FrameStorageAdapter(this.frame, this.frameReader, this.segmentId.getInterval());
    }

    @Override
    public void close() {
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        if (CloseableShapeshifter.class.equals(clazz)) {
            return (T)new FrameRowsAndColumns(this.frame, this.frameReader.signature());
        }
        return Segment.super.as(clazz);
    }
}

