/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.row;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.frame.segment.FrameCursorUtils;
import org.apache.druid.frame.segment.FrameFilteredOffset;
import org.apache.druid.frame.segment.row.CursorFrameRowPointer;
import org.apache.druid.frame.segment.row.FrameColumnSelectorFactory;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class FrameCursorFactory
implements CursorFactory {
    private final Frame frame;
    private final FrameReader frameReader;
    private final List<FieldReader> fieldReaders;

    public FrameCursorFactory(Frame frame, FrameReader frameReader, List<FieldReader> fieldReaders) {
        this.frame = FrameType.ROW_BASED.ensureType(frame);
        this.frameReader = frameReader;
        this.fieldReaders = fieldReaders;
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        if (Granularities.ALL.equals(gran)) {
            Cursor cursor = this.makeGranularityAllCursor(filter, interval, virtualColumns, descending);
            return Sequences.simple(Collections.singletonList(cursor));
        }
        throw new UOE("Granularity [%s] not supported", gran);
    }

    private Cursor makeGranularityAllCursor(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending) {
        Filter filterToUse = FrameCursorUtils.buildFilter(filter, interval);
        SimpleSettableOffset baseOffset = descending ? new SimpleDescendingOffset(this.frame.numRows()) : new SimpleAscendingOffset(this.frame.numRows());
        ColumnSelectorFactory columnSelectorFactory = virtualColumns.wrap(new FrameColumnSelectorFactory(this.frame, this.frameReader.signature(), this.fieldReaders, new CursorFrameRowPointer(this.frame, baseOffset)));
        SimpleSettableOffset offset = filterToUse == null ? baseOffset : new FrameFilteredOffset(baseOffset, columnSelectorFactory, filterToUse);
        return new FrameCursor(offset, columnSelectorFactory);
    }
}

