/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;

public abstract class StringFrameColumnWriter<T extends ColumnValueSelector>
implements FrameColumnWriter {
    private static final int INITIAL_ALLOCATION_SIZE = 120;
    public static final long DATA_OFFSET = 2L;
    private final T selector;
    private final byte typeCode;
    protected final ColumnCapabilities.Capable multiValue;
    protected boolean encounteredMultiValueRow;
    private final AppendableMemory cumulativeRowLengths;
    private final AppendableMemory cumulativeStringLengths;
    private final AppendableMemory stringData;
    private int lastCumulativeRowLength = 0;
    private int lastRowLength = 0;
    private int lastCumulativeStringLength = 0;
    private int lastStringLength = -1;

    StringFrameColumnWriter(T selector, MemoryAllocator allocator, byte typeCode, ColumnCapabilities.Capable multiValue) {
        this.selector = selector;
        this.typeCode = typeCode;
        this.multiValue = multiValue;
        this.cumulativeRowLengths = multiValue.isMaybeTrue() ? AppendableMemory.create(allocator, 120) : null;
        this.cumulativeStringLengths = AppendableMemory.create(allocator, 120);
        this.stringData = AppendableMemory.create(allocator, 120);
    }

    @Override
    public boolean addSelection() {
        List<ByteBuffer> utf8Data = this.getUtf8ByteBuffersFromSelector(this.selector);
        int utf8Count = utf8Data == null ? 0 : utf8Data.size();
        int utf8DataByteLength = StringFrameColumnWriter.countBytes(utf8Data);
        if ((long)this.lastCumulativeRowLength + (long)utf8Count > Integer.MAX_VALUE) {
            return false;
        }
        if ((long)this.lastCumulativeStringLength + (long)utf8DataByteLength > Integer.MAX_VALUE) {
            return false;
        }
        if (this.multiValue.isMaybeTrue() && !this.cumulativeRowLengths.reserveAdditional(4)) {
            return false;
        }
        if (!this.cumulativeStringLengths.reserveAdditional(4 * utf8Count)) {
            return false;
        }
        if (!this.stringData.reserveAdditional(utf8DataByteLength)) {
            return false;
        }
        if (utf8Count != 1) {
            this.encounteredMultiValueRow = true;
            if (this.multiValue.isFalse()) {
                throw new ISE("Encountered unexpected multi-value row, size[%d]", utf8Count);
            }
        }
        if (this.multiValue.isMaybeTrue()) {
            MemoryRange<WritableMemory> rowLengthsCursor = this.cumulativeRowLengths.cursor();
            if (utf8Data == null && this.typeCode == 6) {
                rowLengthsCursor.memory().putInt(rowLengthsCursor.start(), -(this.lastCumulativeRowLength + utf8Count) - 1);
            } else {
                rowLengthsCursor.memory().putInt(rowLengthsCursor.start(), this.lastCumulativeRowLength + utf8Count);
            }
            this.cumulativeRowLengths.advanceCursor(4);
            this.lastRowLength = utf8Count;
            this.lastCumulativeRowLength += utf8Count;
        }
        MemoryRange<WritableMemory> stringLengthsCursor = utf8Count > 0 ? this.cumulativeStringLengths.cursor() : null;
        MemoryRange<WritableMemory> stringDataCursor = utf8DataByteLength > 0 ? this.stringData.cursor() : null;
        this.lastStringLength = 0;
        for (int i = 0; i < utf8Count; ++i) {
            ByteBuffer utf8Datum = utf8Data.get(i);
            int len = utf8Datum.remaining();
            if (len > 0) {
                assert (stringDataCursor != null);
                FrameWriterUtils.copyByteBufferToMemory(utf8Datum, stringDataCursor.memory(), stringDataCursor.start() + (long)this.lastStringLength, len, true);
            }
            this.lastStringLength += len;
            this.lastCumulativeStringLength += len;
            assert (stringLengthsCursor != null);
            stringLengthsCursor.memory().putInt(stringLengthsCursor.start() + 4L * (long)i, this.lastCumulativeStringLength);
        }
        if (utf8Count > 0) {
            this.cumulativeStringLengths.advanceCursor(4 * utf8Count);
        }
        if (utf8DataByteLength > 0) {
            this.stringData.advanceCursor(this.lastStringLength);
        }
        return true;
    }

    @Override
    public void undo() {
        if (this.lastStringLength == -1) {
            throw new ISE("Cannot undo", new Object[0]);
        }
        if (this.multiValue.isMaybeTrue()) {
            this.cumulativeRowLengths.rewindCursor(4);
            this.cumulativeStringLengths.rewindCursor(4 * this.lastRowLength);
            this.lastCumulativeRowLength -= this.lastRowLength;
            this.lastRowLength = 0;
        } else {
            this.cumulativeStringLengths.rewindCursor(4);
        }
        this.stringData.rewindCursor(this.lastStringLength);
        this.lastCumulativeStringLength -= this.lastStringLength;
        this.lastStringLength = -1;
    }

    @Override
    public long size() {
        return 2L + (this.isWriteMultiValue() ? this.cumulativeRowLengths.size() : 0L) + this.cumulativeStringLengths.size() + this.stringData.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        boolean writeMultiValue = this.isWriteMultiValue();
        long currentPosition = startPosition;
        memory.putByte(currentPosition, this.typeCode);
        memory.putByte(currentPosition + 1L, writeMultiValue ? (byte)1 : 0);
        currentPosition += 2L;
        if (writeMultiValue) {
            currentPosition += this.cumulativeRowLengths.writeTo(memory, currentPosition);
        }
        currentPosition += this.cumulativeStringLengths.writeTo(memory, currentPosition);
        currentPosition += this.stringData.writeTo(memory, currentPosition);
        return currentPosition - startPosition;
    }

    @Override
    public void close() {
        if (this.multiValue.isMaybeTrue()) {
            this.cumulativeRowLengths.close();
        }
        this.cumulativeStringLengths.close();
        this.stringData.close();
    }

    @Nullable
    public abstract List<ByteBuffer> getUtf8ByteBuffersFromSelector(T var1);

    private boolean isWriteMultiValue() {
        return this.multiValue.isTrue() || this.encounteredMultiValueRow;
    }

    private static int countBytes(@Nullable List<ByteBuffer> buffers) {
        if (buffers == null) {
            return 0;
        }
        long count = 0L;
        for (ByteBuffer buffer : buffers) {
            count += (long)buffer.remaining();
        }
        return Ints.checkedCast((long)count);
    }
}

