/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.google.common.collect.FluentIterable;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.apache.druid.data.input.impl.FastJacksonJsonNodeJsonProvider;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;

public class JSONFlattenerMaker
implements ObjectFlatteners.FlattenerMaker<JsonNode> {
    private static final JsonProvider JSON_PROVIDER = new FastJacksonJsonNodeJsonProvider();
    private static final Configuration JSONPATH_CONFIGURATION = Configuration.builder().jsonProvider(JSON_PROVIDER).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(EnumSet.of(Option.SUPPRESS_EXCEPTIONS)).build();
    private final CharsetEncoder enc = StandardCharsets.UTF_8.newEncoder();
    private final boolean keepNullValues;
    private final boolean discoverNestedFields;

    public JSONFlattenerMaker(boolean keepNullValues, boolean discoverNestedFields) {
        this.keepNullValues = keepNullValues;
        this.discoverNestedFields = discoverNestedFields;
    }

    @Override
    public Iterable<String> discoverRootFields(JsonNode obj) {
        if (this.discoverNestedFields) {
            return () -> ((JsonNode)obj).fieldNames();
        }
        return FluentIterable.from(() -> ((JsonNode)obj).fields()).filter(entry -> {
            JsonNode val = (JsonNode)entry.getValue();
            return !(val.isObject() || !this.keepNullValues && val.isNull() || val.isArray() && !JSONFlattenerMaker.isFlatList(val));
        }).transform(Map.Entry::getKey);
    }

    @Override
    public Object getRootField(JsonNode obj, String key) {
        return this.finalizeConversionForMap(obj.get(key));
    }

    @Override
    public Function<JsonNode, Object> makeJsonPathExtractor(String expr) {
        JsonPath jsonPath = JsonPath.compile((String)expr, (Predicate[])new Predicate[0]);
        return node -> this.finalizeConversionForMap(jsonPath.read(node, JSONPATH_CONFIGURATION));
    }

    @Override
    public Function<JsonNode, Object> makeJsonQueryExtractor(String expr) {
        try {
            JsonQuery jsonQuery = JsonQuery.compile((String)expr);
            return jsonNode -> {
                try {
                    return this.finalizeConversionForMap(jsonQuery.apply(jsonNode).get(0));
                }
                catch (JsonQueryException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (JsonQueryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Function<JsonNode, Object> makeJsonTreeExtractor(List<String> nodes) {
        String[] keyNames = nodes.toArray(new String[0]);
        return jsonNode -> {
            JsonNode targetNode = jsonNode;
            for (String keyName : keyNames) {
                if (targetNode == null) {
                    return null;
                }
                targetNode = targetNode.get(keyName);
            }
            return this.finalizeConversionForMap(targetNode);
        };
    }

    @Override
    public JsonProvider getJsonProvider() {
        return JSON_PROVIDER;
    }

    @Override
    public Object finalizeConversionForMap(Object o) {
        if (o instanceof JsonNode) {
            return JSONFlattenerMaker.convertJsonNode((JsonNode)o, this.enc);
        }
        return o;
    }

    @Nullable
    public static Object convertJsonNode(JsonNode val, CharsetEncoder enc) {
        if (val == null || val.isNull()) {
            return null;
        }
        if (val.isInt() || val.isLong()) {
            return val.asLong();
        }
        if (val.isNumber()) {
            return val.asDouble();
        }
        if (val.isTextual()) {
            return JSONFlattenerMaker.charsetFix(val.asText(), enc);
        }
        if (val.isBoolean()) {
            return val.asBoolean();
        }
        if (val.isBinary() && val instanceof BinaryNode) {
            return ((BinaryNode)val).binaryValue();
        }
        if (val.isArray()) {
            ArrayList<Object> newList = new ArrayList<Object>();
            for (JsonNode entry : val) {
                newList.add(JSONFlattenerMaker.convertJsonNode(entry, enc));
            }
            return newList;
        }
        if (val.isObject()) {
            LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
            Iterator it = val.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                newMap.put((String)entry.getKey(), JSONFlattenerMaker.convertJsonNode((JsonNode)entry.getValue(), enc));
            }
            return newMap;
        }
        return null;
    }

    @Nullable
    private static String charsetFix(String s, CharsetEncoder enc) {
        if (s != null && !enc.canEncode(s)) {
            return StringUtils.fromUtf8(StringUtils.toUtf8(s));
        }
        return s;
    }

    private static boolean isFlatList(JsonNode list) {
        for (JsonNode obj : list) {
            if (!obj.isObject() && !obj.isArray()) continue;
            return false;
        }
        return true;
    }
}

