/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client;

import javax.net.ssl.SSLContext;
import org.apache.druid.java.util.http.client.HttpClientProxyConfig;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.Duration;
import org.joda.time.Period;

public class HttpClientConfig {
    public static final CompressionCodec DEFAULT_COMPRESSION_CODEC = CompressionCodec.GZIP;
    private static final int DEFAULT_BOSS_COUNT = 1;
    private static final int DEFAULT_WORKER_COUNT = JvmUtils.getRuntimeInfo().getAvailableProcessors() * 2;
    private static final Duration DEFAULT_UNUSED_CONNECTION_TIMEOUT_DURATION = new Period((Object)"PT4M").toStandardDuration();
    private final int numConnections;
    private final boolean eagerInitialization;
    private final SSLContext sslContext;
    private final HttpClientProxyConfig proxyConfig;
    private final Duration readTimeout;
    private final Duration sslHandshakeTimeout;
    private final int bossPoolSize;
    private final int workerPoolSize;
    private final CompressionCodec compressionCodec;
    private final Duration unusedConnectionTimeoutDuration;

    public static Builder builder() {
        return new Builder();
    }

    private HttpClientConfig(int numConnections, boolean eagerInitialization, SSLContext sslContext, HttpClientProxyConfig proxyConfig, Duration readTimeout, Duration sslHandshakeTimeout, int bossPoolSize, int workerPoolSize, CompressionCodec compressionCodec, Duration unusedConnectionTimeoutDuration) {
        this.numConnections = numConnections;
        this.eagerInitialization = eagerInitialization;
        this.sslContext = sslContext;
        this.proxyConfig = proxyConfig;
        this.readTimeout = readTimeout;
        this.sslHandshakeTimeout = sslHandshakeTimeout;
        this.bossPoolSize = bossPoolSize;
        this.workerPoolSize = workerPoolSize;
        this.compressionCodec = compressionCodec;
        this.unusedConnectionTimeoutDuration = unusedConnectionTimeoutDuration;
    }

    public int getNumConnections() {
        return this.numConnections;
    }

    public boolean isEagerInitialization() {
        return this.eagerInitialization;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HttpClientProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public int getBossPoolSize() {
        return this.bossPoolSize;
    }

    public int getWorkerPoolSize() {
        return this.workerPoolSize;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public Duration getUnusedConnectionTimeoutDuration() {
        return this.unusedConnectionTimeoutDuration;
    }

    static /* synthetic */ int access$200() {
        return DEFAULT_WORKER_COUNT;
    }

    static /* synthetic */ Duration access$300() {
        return DEFAULT_UNUSED_CONNECTION_TIMEOUT_DURATION;
    }

    public static class Builder {
        private int numConnections = 1;
        private boolean eagerInitialization = true;
        private SSLContext sslContext = null;
        private HttpClientProxyConfig proxyConfig = null;
        private Duration readTimeout = null;
        private Duration sslHandshakeTimeout = null;
        private int bossCount = 1;
        private int workerCount = HttpClientConfig.access$200();
        private CompressionCodec compressionCodec = DEFAULT_COMPRESSION_CODEC;
        private Duration unusedConnectionTimeoutDuration = HttpClientConfig.access$300();

        private Builder() {
        }

        public Builder withNumConnections(int numConnections) {
            this.numConnections = numConnections;
            return this;
        }

        public Builder withEagerInitialization(boolean eagerInitialization) {
            this.eagerInitialization = eagerInitialization;
            return this;
        }

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withHttpProxyConfig(HttpClientProxyConfig config) {
            this.proxyConfig = config;
            return this;
        }

        public Builder withReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder withSslHandshakeTimeout(Duration sslHandshakeTimeout) {
            this.sslHandshakeTimeout = sslHandshakeTimeout;
            return this;
        }

        public Builder withWorkerCount(int workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        public Builder withCompressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        public Builder withUnusedConnectionTimeoutDuration(Duration unusedConnectionTimeoutDuration) {
            this.unusedConnectionTimeoutDuration = unusedConnectionTimeoutDuration;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.numConnections, this.eagerInitialization, this.sslContext, this.proxyConfig, this.readTimeout, this.sslHandshakeTimeout, this.bossCount, this.workerCount, this.compressionCodec, this.unusedConnectionTimeoutDuration);
        }
    }

    public static enum CompressionCodec {
        IDENTITY{

            @Override
            public String getEncodingString() {
                return "identity";
            }
        }
        ,
        GZIP{

            @Override
            public String getEncodingString() {
                return "gzip";
            }
        }
        ,
        DEFLATE{

            @Override
            public String getEncodingString() {
                return "deflate";
            }
        };


        public abstract String getEncodingString();
    }
}

