/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CpuSet;

public class CgroupCpuSetMonitor
extends FeedDefiningMonitor {
    final CgroupDiscoverer cgroupDiscoverer;
    final Map<String, String[]> dimensions;

    public CgroupCpuSetMonitor(CgroupDiscoverer cgroupDiscoverer, Map<String, String[]> dimensions, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
        this.dimensions = dimensions;
    }

    public CgroupCpuSetMonitor(Map<String, String[]> dimensions, String feed) {
        this(null, dimensions, feed);
    }

    public CgroupCpuSetMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public CgroupCpuSetMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        CpuSet cpuset = new CpuSet(this.cgroupDiscoverer);
        CpuSet.CpuSetMetric cpusetSnapshot = cpuset.snapshot();
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        emitter.emit(builder.setMetric("cgroup/cpuset/cpu_count", cpusetSnapshot.getCpuSetCpus().length));
        emitter.emit(builder.setMetric("cgroup/cpuset/effective_cpu_count", cpusetSnapshot.getEffectiveCpuSetCpus().length));
        emitter.emit(builder.setMetric("cgroup/cpuset/mems_count", cpusetSnapshot.getCpuSetMems().length));
        emitter.emit(builder.setMetric("cgroup/cpuset/effective_mems_count", cpusetSnapshot.getEffectiveCpuSetMems().length));
        return true;
    }
}

