/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AllocationMetricCollector;
import org.apache.druid.java.util.metrics.AllocationMetricCollectors;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;

public class JvmMonitor
extends FeedDefiningMonitor {
    private final Map<String, String[]> dimensions;
    @Nullable
    @VisibleForTesting
    final GcCollectors gcCollectors;
    @Nullable
    private final AllocationMetricCollector collector;

    public JvmMonitor() {
        this((Map<String, String[]>)ImmutableMap.of());
    }

    public JvmMonitor(Map<String, String[]> dimensions) {
        this(dimensions, "metrics");
    }

    public JvmMonitor(Map<String, String[]> dimensions, String feed) {
        super(feed);
        Preconditions.checkNotNull(dimensions);
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.collector = AllocationMetricCollectors.getAllocationMetricCollector();
        this.gcCollectors = new GcCollectors();
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        this.emitJvmMemMetrics(emitter);
        this.emitDirectMemMetrics(emitter);
        this.emitGcMetrics(emitter);
        this.emitThreadAllocationMetrics(emitter);
        return true;
    }

    private void emitThreadAllocationMetrics(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder = this.builder();
        MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
        if (this.collector != null) {
            long delta = this.collector.calculateDelta();
            emitter.emit(builder.setMetric("jvm/heapAlloc/bytes", delta));
        }
    }

    @Deprecated
    private void emitJvmMemMetrics(ServiceEmitter emitter) {
        ServiceMetricEvent.Builder builder;
        MemoryUsage usage;
        String kind;
        ImmutableMap usages = ImmutableMap.of((Object)"heap", (Object)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), (Object)"nonheap", (Object)ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
        for (Map.Entry entry : usages.entrySet()) {
            kind = (String)entry.getKey();
            usage = (MemoryUsage)entry.getValue();
            builder = this.builder().setDimension("memKind", kind);
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.setMetric("jvm/mem/max", usage.getMax()));
            emitter.emit(builder.setMetric("jvm/mem/committed", usage.getCommitted()));
            emitter.emit(builder.setMetric("jvm/mem/used", usage.getUsed()));
            emitter.emit(builder.setMetric("jvm/mem/init", usage.getInit()));
        }
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            kind = pool.getType() == MemoryType.HEAP ? "heap" : "nonheap";
            usage = pool.getUsage();
            builder = this.builder().setDimension("poolKind", kind).setDimension("poolName", pool.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.setMetric("jvm/pool/max", usage.getMax()));
            emitter.emit(builder.setMetric("jvm/pool/committed", usage.getCommitted()));
            emitter.emit(builder.setMetric("jvm/pool/used", usage.getUsed()));
            emitter.emit(builder.setMetric("jvm/pool/init", usage.getInit()));
        }
    }

    private void emitDirectMemMetrics(ServiceEmitter emitter) {
        for (BufferPoolMXBean pool : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            ServiceMetricEvent.Builder builder = this.builder().setDimension("bufferpoolName", pool.getName());
            MonitorUtils.addDimensionsToBuilder(builder, this.dimensions);
            emitter.emit(builder.setMetric("jvm/bufferpool/capacity", pool.getTotalCapacity()));
            emitter.emit(builder.setMetric("jvm/bufferpool/used", pool.getMemoryUsed()));
            emitter.emit(builder.setMetric("jvm/bufferpool/count", pool.getCount()));
        }
    }

    private void emitGcMetrics(ServiceEmitter emitter) {
        this.gcCollectors.emit(emitter, this.dimensions);
    }

    private class GcGenerationSpace {
        private final String name;
        private final MemoryUsage memoryUsage;

        public GcGenerationSpace(MemoryUsage memoryUsage, String name) {
            this.memoryUsage = memoryUsage;
            this.name = name;
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            ServiceMetricEvent.Builder builder = JvmMonitor.this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, dimensions);
            builder.setDimension("gcGenSpaceName", this.name);
            emitter.emit(builder.setMetric("jvm/gc/mem/max", this.memoryUsage.getMax()));
            emitter.emit(builder.setMetric("jvm/gc/mem/capacity", this.memoryUsage.getCommitted()));
            emitter.emit(builder.setMetric("jvm/gc/mem/used", this.memoryUsage.getUsed()));
            emitter.emit(builder.setMetric("jvm/gc/mem/init", this.memoryUsage.getInit()));
        }
    }

    private class GcSpaceCollector {
        private final List<GcGenerationSpace> spaces = new ArrayList<GcGenerationSpace>();

        public GcSpaceCollector(MemoryUsage collectionUsage, String name) {
            this.spaces.add(new GcGenerationSpace(collectionUsage, name));
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            for (GcGenerationSpace space : this.spaces) {
                space.emit(emitter, dimensions);
            }
        }
    }

    private class GcGenerationCollector {
        private final String generation;
        private final String collectorName;
        private final GarbageCollectorMXBean gcBean;
        private long lastInvocations = 0L;
        private long lastCpuMillis = 0L;
        private static final String GC_YOUNG_GENERATION_NAME = "young";
        private static final String GC_OLD_GENERATION_NAME = "old";
        private static final String GC_ZGC_GENERATION_NAME = "zgc";
        private static final String CMS_COLLECTOR_NAME = "cms";
        private static final String G1_COLLECTOR_NAME = "g1";
        private static final String PARALLEL_COLLECTOR_NAME = "parallel";
        private static final String SERIAL_COLLECTOR_NAME = "serial";
        private static final String ZGC_COLLECTOR_NAME = "zgc";
        private static final String SHENANDOAN_COLLECTOR_NAME = "shenandoah";

        GcGenerationCollector(GarbageCollectorMXBean gcBean) {
            Pair<String, String> gcNamePair = this.getReadableName(gcBean.getName());
            this.generation = (String)gcNamePair.lhs;
            this.collectorName = (String)gcNamePair.rhs;
            this.gcBean = gcBean;
        }

        private Pair<String, String> getReadableName(String name) {
            switch (name) {
                case "ParNew": {
                    return new Pair<String, String>(GC_YOUNG_GENERATION_NAME, CMS_COLLECTOR_NAME);
                }
                case "ConcurrentMarkSweep": {
                    return new Pair<String, String>(GC_OLD_GENERATION_NAME, CMS_COLLECTOR_NAME);
                }
                case "G1 Young Generation": {
                    return new Pair<String, String>(GC_YOUNG_GENERATION_NAME, G1_COLLECTOR_NAME);
                }
                case "G1 Old Generation": {
                    return new Pair<String, String>(GC_OLD_GENERATION_NAME, G1_COLLECTOR_NAME);
                }
                case "PS Scavenge": {
                    return new Pair<String, String>(GC_YOUNG_GENERATION_NAME, PARALLEL_COLLECTOR_NAME);
                }
                case "PS MarkSweep": {
                    return new Pair<String, String>(GC_OLD_GENERATION_NAME, PARALLEL_COLLECTOR_NAME);
                }
                case "Copy": {
                    return new Pair<String, String>(GC_YOUNG_GENERATION_NAME, SERIAL_COLLECTOR_NAME);
                }
                case "MarkSweepCompact": {
                    return new Pair<String, String>(GC_OLD_GENERATION_NAME, SERIAL_COLLECTOR_NAME);
                }
                case "ZGC": {
                    return new Pair<String, String>("zgc", "zgc");
                }
                case "Shenandoah Cycles": {
                    return new Pair<String, String>(GC_YOUNG_GENERATION_NAME, SHENANDOAN_COLLECTOR_NAME);
                }
                case "Shenandoah Pauses": {
                    return new Pair<String, String>(GC_OLD_GENERATION_NAME, SHENANDOAN_COLLECTOR_NAME);
                }
            }
            return new Pair<String, String>(name, name);
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            ImmutableMap.Builder dimensionsCopyBuilder = ImmutableMap.builder().putAll(dimensions).put((Object)"gcGen", (Object)new String[]{this.generation});
            dimensionsCopyBuilder.put((Object)"gcName", (Object)new String[]{this.collectorName});
            ImmutableMap dimensionsCopy = dimensionsCopyBuilder.build();
            ServiceMetricEvent.Builder builder = JvmMonitor.this.builder();
            MonitorUtils.addDimensionsToBuilder(builder, (Map<String, String[]>)dimensionsCopy);
            long newInvocations = this.gcBean.getCollectionCount();
            emitter.emit(builder.setMetric("jvm/gc/count", newInvocations - this.lastInvocations));
            this.lastInvocations = newInvocations;
            long newCpuMillis = this.gcBean.getCollectionTime();
            emitter.emit(builder.setMetric("jvm/gc/cpu", (newCpuMillis - this.lastCpuMillis) * 1000000L));
            this.lastCpuMillis = newCpuMillis;
        }
    }

    private class GcCollectors {
        private final List<GcGenerationCollector> generationCollectors = new ArrayList<GcGenerationCollector>();
        private final List<GcSpaceCollector> spaceCollectors = new ArrayList<GcSpaceCollector>();

        GcCollectors() {
            List<GarbageCollectorMXBean> collectorMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean collectorMxBean : collectorMxBeans) {
                this.generationCollectors.add(new GcGenerationCollector(collectorMxBean));
            }
            List<MemoryPoolMXBean> memoryPoolMxBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMxBean : memoryPoolMxBeans) {
                MemoryUsage collectionUsage = memoryPoolMxBean.getCollectionUsage();
                if (collectionUsage == null) continue;
                this.spaceCollectors.add(new GcSpaceCollector(collectionUsage, memoryPoolMxBean.getName()));
            }
        }

        void emit(ServiceEmitter emitter, Map<String, String[]> dimensions) {
            for (GcGenerationCollector generationCollector : this.generationCollectors) {
                generationCollector.emit(emitter, dimensions);
            }
            for (GcSpaceCollector spaceCollector : this.spaceCollectors) {
                spaceCollector.emit(emitter, dimensions);
            }
        }
    }
}

