/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import com.google.common.primitives.Longs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;

public class Cpu {
    private static final Logger LOG = new Logger(Cpu.class);
    private static final String CGROUP = "cpu";
    private static final String CPU_SHARES_FILE = "cpu.shares";
    private static final String CPU_QUOTA_FILE = "cpu.cfs_quota_us";
    private static final String CPU_PERIOD_FILE = "cpu.cfs_period_us";
    private final CgroupDiscoverer cgroupDiscoverer;

    public Cpu(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CpuAllocationMetric snapshot() {
        return new CpuAllocationMetric(this.readLongValue(CPU_SHARES_FILE, -1L), this.readLongValue(CPU_QUOTA_FILE, 0L), this.readLongValue(CPU_PERIOD_FILE, 0L));
    }

    private long readLongValue(String fileName, long defaultValeue) {
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), fileName));
            return lines.stream().map(Longs::tryParse).filter(Objects::nonNull).findFirst().orElse(defaultValeue);
        }
        catch (IOException | RuntimeException ex) {
            LOG.error(ex, "Unable to fetch %s", fileName);
            return defaultValeue;
        }
    }

    public static class CpuAllocationMetric {
        private final long shares;
        private final long quotaUs;
        private final long periodUs;

        CpuAllocationMetric(long shares, long quotaUs, long periodUs) {
            this.shares = shares;
            this.quotaUs = quotaUs;
            this.periodUs = periodUs;
        }

        public final long getShares() {
            return this.shares;
        }

        public final long getQuotaUs() {
            return this.quotaUs;
        }

        public final long getPeriodUs() {
            return this.periodUs;
        }
    }
}

