/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.ApplyFunction;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.LambdaExpr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

class ApplyFunctionExpr
implements Expr {
    final ApplyFunction function;
    final String name;
    final LambdaExpr lambdaExpr;
    final ImmutableList<Expr> argsExpr;
    final Expr.BindingAnalysis bindingAnalysis;
    final Expr.BindingAnalysis lambdaBindingAnalysis;
    final ImmutableList<Expr.BindingAnalysis> argsBindingAnalyses;

    ApplyFunctionExpr(ApplyFunction function, String name, LambdaExpr expr, List<Expr> args) {
        this.function = function;
        this.name = name;
        this.argsExpr = ImmutableList.copyOf(args);
        this.lambdaExpr = expr;
        function.validateArguments(expr, args);
        ImmutableList.Builder argBindingDetailsBuilder = ImmutableList.builder();
        Expr.BindingAnalysis accumulator = new Expr.BindingAnalysis();
        for (Expr arg : this.argsExpr) {
            Expr.BindingAnalysis argDetails = arg.analyzeInputs();
            argBindingDetailsBuilder.add((Object)argDetails);
            accumulator = accumulator.with(argDetails);
        }
        this.lambdaBindingAnalysis = this.lambdaExpr.analyzeInputs();
        this.bindingAnalysis = accumulator.with(this.lambdaBindingAnalysis).withArrayArguments(function.getArrayInputs((List<Expr>)this.argsExpr)).withArrayInputs(true).withArrayOutput(function.hasArrayOutput(this.lambdaExpr));
        this.argsBindingAnalyses = argBindingDetailsBuilder.build();
    }

    public String toString() {
        return StringUtils.format("(%s %s, %s)", this.name, this.lambdaExpr, this.argsExpr);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return this.function.apply(this.lambdaExpr, (List<Expr>)this.argsExpr, bindings);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return this.function.canVectorize(inspector, this.lambdaExpr, (List<Expr>)this.argsExpr) && this.lambdaExpr.canVectorize(inspector) && this.argsExpr.stream().allMatch(expr -> expr.canVectorize(inspector));
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return this.function.asVectorProcessor(inspector, this.lambdaExpr, (List<Expr>)this.argsExpr);
    }

    @Override
    public String stringify() {
        return StringUtils.format("%s(%s, %s)", this.name, this.lambdaExpr.stringify(), ARG_JOINER.join(this.argsExpr.stream().map(Expr::stringify).iterator()));
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        LambdaExpr newLambda = (LambdaExpr)this.lambdaExpr.visit(shuttle);
        return shuttle.visit(new ApplyFunctionExpr(this.function, this.name, newLambda, shuttle.visitAll((List<Expr>)this.argsExpr)));
    }

    @Override
    public Expr.BindingAnalysis analyzeInputs() {
        return this.bindingAnalysis;
    }

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return this.function.getOutputType(inspector, this.lambdaExpr, (List<Expr>)this.argsExpr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplyFunctionExpr that = (ApplyFunctionExpr)o;
        return this.name.equals(that.name) && this.lambdaExpr.equals(that.lambdaExpr) && this.argsExpr.equals(that.argsExpr);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.lambdaExpr, this.argsExpr);
    }
}

