/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;

public class Evals {
    public static boolean isAllConstants(Expr ... exprs) {
        return Evals.isAllConstants(Arrays.asList(exprs));
    }

    public static boolean isAllConstants(List<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr instanceof ConstantExpr) continue;
            return false;
        }
        return true;
    }

    public static long asLong(boolean x) {
        return x ? 1L : 0L;
    }

    public static double asDouble(boolean x) {
        return x ? 1.0 : 0.0;
    }

    public static boolean asBoolean(long x) {
        return x > 0L;
    }

    public static boolean asBoolean(double x) {
        return x > 0.0;
    }

    public static boolean asBoolean(@Nullable String x) {
        return !NullHandling.isNullOrEquivalent(x) && Boolean.parseBoolean(x);
    }

    public static boolean objectAsBoolean(@Nullable Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Evals.asBoolean((String)val);
        }
        if (val instanceof Long) {
            return Evals.asBoolean((Long)val);
        }
        if (val instanceof Number) {
            return Evals.asBoolean(((Number)val).doubleValue());
        }
        return false;
    }

    @Nullable
    public static String asString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }
}

