/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class ExpressionProcessingConfig {
    private static final Logger LOG = new Logger(ExpressionProcessingConfig.class);
    public static final String NULL_HANDLING_LEGACY_LOGICAL_OPS_STRING = "druid.expressions.useStrictBooleans";
    public static final String PROCESS_ARRAYS_AS_MULTIVALUE_STRINGS_CONFIG_STRING = "druid.expressions.processArraysAsMultiValueStrings";
    public static final String HOMOGENIZE_NULL_MULTIVALUE_STRING_ARRAYS = "druid.expressions.homogenizeNullMultiValueStringArrays";
    @JsonProperty(value="useStrictBooleans")
    private final boolean useStrictBooleans;
    @JsonProperty(value="processArraysAsMultiValueStrings")
    private final boolean processArraysAsMultiValueStrings;
    @JsonProperty(value="homogenizeNullMultiValueStringArrays")
    private final boolean homogenizeNullMultiValueStringArrays;

    @JsonCreator
    public ExpressionProcessingConfig(@JsonProperty(value="useStrictBooleans") @Nullable Boolean useStrictBooleans, @JsonProperty(value="processArraysAsMultiValueStrings") @Nullable Boolean processArraysAsMultiValueStrings, @JsonProperty(value="homogenizeNullMultiValueStringArrays") @Nullable Boolean homogenizeNullMultiValueStringArrays) {
        this.useStrictBooleans = ExpressionProcessingConfig.getWithPropertyFallback(useStrictBooleans, NULL_HANDLING_LEGACY_LOGICAL_OPS_STRING, "true");
        this.processArraysAsMultiValueStrings = ExpressionProcessingConfig.getWithPropertyFallbackFalse(processArraysAsMultiValueStrings, PROCESS_ARRAYS_AS_MULTIVALUE_STRINGS_CONFIG_STRING);
        this.homogenizeNullMultiValueStringArrays = ExpressionProcessingConfig.getWithPropertyFallbackFalse(homogenizeNullMultiValueStringArrays, HOMOGENIZE_NULL_MULTIVALUE_STRING_ARRAYS);
        String version = ExpressionProcessingConfig.class.getPackage().getImplementationVersion();
        if (version == null || version.contains("SNAPSHOT")) {
            version = "latest";
        }
        String docsBaseFormat = "https://druid.apache.org/docs/%s/querying/sql-data-types#%s";
        if (!this.useStrictBooleans) {
            LOG.warn("druid.expressions.useStrictBooleans set to 'false', we recommend using 'true' if using SQL to query Druid for the most SQL compliant behavior, see %s for details", StringUtils.format("https://druid.apache.org/docs/%s/querying/sql-data-types#%s", version, "boolean-logic"));
        }
    }

    public boolean isUseStrictBooleans() {
        return this.useStrictBooleans;
    }

    public boolean processArraysAsMultiValueStrings() {
        return this.processArraysAsMultiValueStrings;
    }

    public boolean isHomogenizeNullMultiValueStringArrays() {
        return this.homogenizeNullMultiValueStringArrays;
    }

    private static boolean getWithPropertyFallbackFalse(@Nullable Boolean value, String property) {
        return ExpressionProcessingConfig.getWithPropertyFallback(value, property, "false");
    }

    private static boolean getWithPropertyFallback(@Nullable Boolean value, String property, String fallback) {
        return value != null ? value : Boolean.valueOf(System.getProperty(property, fallback));
    }
}

