/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.BinAndExpr;
import org.apache.druid.math.expr.BinEqExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.FunctionExpr;
import org.apache.druid.segment.join.Equality;
import org.apache.druid.segment.join.JoinPrefixUtils;

public class Exprs {
    public static final byte EXPR_CACHE_KEY = 0;

    public static UnsupportedOperationException cannotVectorize(Expr expr) {
        return new UOE("Unable to vectorize expression:[%s]", expr.stringify());
    }

    public static UnsupportedOperationException cannotVectorize(Function function) {
        return new UOE("Unable to vectorize function:[%s]", function.name());
    }

    public static UnsupportedOperationException cannotVectorize() {
        return new UOE("Unable to vectorize expression", new Object[0]);
    }

    public static UnsupportedOperationException cannotVectorize(String msg) {
        return new UOE("Unable to vectorize expression: %s", msg);
    }

    public static List<Expr> decomposeAnd(Expr expr) {
        ArrayList<Expr> retVal = new ArrayList<Expr>();
        Stack<Expr> stack = new Stack<Expr>();
        stack.push(expr);
        while (!stack.empty()) {
            Expr current = (Expr)stack.pop();
            if (current instanceof BinAndExpr) {
                stack.push(((BinAndExpr)current).right);
                stack.push(((BinAndExpr)current).left);
                continue;
            }
            retVal.add(current);
        }
        return retVal;
    }

    public static Optional<Equality> decomposeEquals(Expr expr, String rightPrefix) {
        boolean includeNull;
        Expr rhs;
        Expr lhs;
        if (expr instanceof BinEqExpr) {
            lhs = ((BinEqExpr)expr).left;
            rhs = ((BinEqExpr)expr).right;
            includeNull = false;
        } else if (expr instanceof FunctionExpr && ((FunctionExpr)expr).function instanceof Function.IsNotDistinctFromFunc) {
            ImmutableList<Expr> args = ((FunctionExpr)expr).args;
            lhs = (Expr)args.get(0);
            rhs = (Expr)args.get(1);
            includeNull = true;
        } else {
            return Optional.empty();
        }
        if (Exprs.isLeftExprAndRightColumn(lhs, rhs, rightPrefix)) {
            return Optional.of(new Equality(lhs, Objects.requireNonNull(rhs.getBindingIfIdentifier()).substring(rightPrefix.length()), includeNull));
        }
        if (Exprs.isLeftExprAndRightColumn(rhs, lhs, rightPrefix)) {
            return Optional.of(new Equality(rhs, Objects.requireNonNull(lhs.getBindingIfIdentifier()).substring(rightPrefix.length()), includeNull));
        }
        return Optional.empty();
    }

    private static boolean isLeftExprAndRightColumn(Expr a, Expr b, String rightPrefix) {
        return a.analyzeInputs().getRequiredBindings().stream().noneMatch(c -> JoinPrefixUtils.isPrefixedBy(c, rightPrefix)) && b.getBindingIfIdentifier() != null && JoinPrefixUtils.isPrefixedBy(b.getBindingIfIdentifier(), rightPrefix);
    }
}

