/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.BivariateFunctionVectorObjectProcessor;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class LongOutObjectsInFunctionVectorProcessor
extends BivariateFunctionVectorObjectProcessor<Object[], Object[], long[]> {
    private final boolean[] outNulls;

    protected LongOutObjectsInFunctionVectorProcessor(ExprVectorProcessor<Object[]> left, ExprVectorProcessor<Object[]> right, int maxVectorSize, ExpressionType inputType) {
        super(CastToTypeVectorProcessor.cast(left, inputType), CastToTypeVectorProcessor.cast(right, inputType), new long[maxVectorSize]);
        this.outNulls = new boolean[maxVectorSize];
    }

    @Nullable
    abstract Long processValue(@Nullable Object var1, @Nullable Object var2);

    @Override
    void processIndex(Object[] in1, Object[] in2, int i) {
        Long outVal = this.processValue(in1[i], in2[i]);
        if (outVal == null) {
            ((long[])this.outValues)[i] = 0L;
            this.outNulls[i] = NullHandling.sqlCompatible();
        } else {
            ((long[])this.outValues)[i] = outVal;
            this.outNulls[i] = false;
        }
    }

    @Override
    void processNull(int i) {
        ((long[])this.outValues)[i] = 0L;
        this.outNulls[i] = NullHandling.sqlCompatible();
    }

    @Override
    ExprEvalVector<long[]> asEval() {
        return new ExprEvalLongVector((long[])this.outValues, this.outNulls);
    }

    @Override
    public ExpressionType getOutputType() {
        return ExpressionType.LONG;
    }
}

