/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.indexer.TaskIdentifier;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;

public interface MetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    public void insert(@NotNull String var1, @NotNull DateTime var2, @NotNull String var3, @NotNull EntryType var4, boolean var5, @Nullable StatusType var6, @NotNull String var7, @NotNull String var8) throws EntryExistsException;

    public boolean setStatus(String var1, boolean var2, StatusType var3);

    public Optional<EntryType> getEntry(String var1);

    public Optional<StatusType> getStatus(String var1);

    @Nullable
    public TaskInfo<EntryType, StatusType> getTaskInfo(String var1);

    public List<TaskInfo<EntryType, StatusType>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> var1, @Nullable String var2);

    public List<TaskInfo<TaskIdentifier, StatusType>> getTaskStatusList(Map<TaskLookup.TaskLookupType, TaskLookup> var1, @Nullable String var2);

    default public List<TaskInfo<EntryType, StatusType>> getTaskInfos(TaskLookup taskLookup, @Nullable String datasource) {
        return this.getTaskInfos(Collections.singletonMap(taskLookup.getType(), taskLookup), datasource);
    }

    public boolean addLock(String var1, LockType var2);

    public boolean replaceLock(String var1, long var2, LockType var4);

    public void removeLock(long var1);

    public void removeTasksOlderThan(long var1);

    public boolean addLog(String var1, LogType var2);

    public List<LogType> getLogs(String var1);

    public Map<Long, LockType> getLocks(String var1);

    @Nullable
    public Long getLockId(String var1, LockType var2);

    public void populateTaskTypeAndGroupIdAsync();
}

