/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.PostProcessingOperator;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.UnionQueryRunner;
import org.apache.druid.query.context.ResponseContext;

public class FluentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryToolChest<T, Query<T>> toolChest;
    private final QueryRunner<T> baseRunner;

    public static <K, J extends Query<K>> FluentQueryRunner<K> create(QueryRunner<K> runner, QueryToolChest<K, J> toolchest) {
        return new FluentQueryRunner<K>(runner, toolchest);
    }

    public FluentQueryRunner(QueryRunner<T> runner, QueryToolChest<T, Query<T>> toolChest) {
        this.baseRunner = runner;
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        return this.baseRunner.run(queryPlus, responseContext);
    }

    public FluentQueryRunner<T> from(QueryRunner<T> runner) {
        return new FluentQueryRunner<T>(runner, this.toolChest);
    }

    public FluentQueryRunner<T> applyPostMergeDecoration() {
        return this.from(new FinalizeResultsQueryRunner<T>(this.toolChest.postMergeQueryDecoration(this.baseRunner), this.toolChest));
    }

    public FluentQueryRunner<T> applyPreMergeDecoration() {
        return this.from(new UnionQueryRunner<T>(this.toolChest.preMergeQueryDecoration(this.baseRunner)));
    }

    public FluentQueryRunner<T> emitCPUTimeMetric(ServiceEmitter emitter) {
        return this.emitCPUTimeMetric(emitter, new AtomicLong(0L));
    }

    public FluentQueryRunner<T> emitCPUTimeMetric(ServiceEmitter emitter, AtomicLong accumulator) {
        return this.from(CPUTimeMetricQueryRunner.safeBuild(this.baseRunner, this.toolChest, emitter, accumulator, true));
    }

    public FluentQueryRunner<T> postProcess(PostProcessingOperator<T> postProcessing) {
        return this.from(postProcessing != null ? postProcessing.postProcess(this.baseRunner) : this.baseRunner);
    }

    public FluentQueryRunner<T> mergeResults() {
        return this.from(this.toolChest.mergeResults(this.baseRunner));
    }

    public FluentQueryRunner<T> map(Function<QueryRunner<T>, QueryRunner<T>> mapFn) {
        return this.from(mapFn.apply(this.baseRunner));
    }

    public QueryRunner<T> setToString(final String toStringValue) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
                return FluentQueryRunner.this.run(queryPlus, responseContext);
            }

            public String toString() {
                return toStringValue;
            }
        };
    }
}

