/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DelegatingBufferAggregator;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableValueFloatColumnValueSelector;

public class StringColumnFloatBufferAggregatorWrapper
extends DelegatingBufferAggregator {
    private final BaseObjectColumnValueSelector selector;
    private final float nullValue;
    private final SettableValueFloatColumnValueSelector floatSelector = new SettableValueFloatColumnValueSelector();

    public StringColumnFloatBufferAggregatorWrapper(BaseObjectColumnValueSelector selector, Function<BaseFloatColumnValueSelector, BufferAggregator> delegateBuilder, float nullValue) {
        this.selector = selector;
        this.nullValue = nullValue;
        this.delegate = delegateBuilder.apply(this.floatSelector);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        Object update = this.selector.getObject();
        if (update == null) {
            this.floatSelector.setValue(this.nullValue);
            this.delegate.aggregate(buf, position);
        } else if (update instanceof List) {
            for (Object o : (List)update) {
                this.floatSelector.setValue(Numbers.tryParseFloat(o, this.nullValue));
                this.delegate.aggregate(buf, position);
            }
        } else {
            this.floatSelector.setValue(Numbers.tryParseFloat(update, this.nullValue));
            this.delegate.aggregate(buf, position);
        }
    }
}

