/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public abstract class NumericAnyVectorAggregator
implements VectorAggregator {
    @VisibleForTesting
    static final byte BYTE_FLAG_FOUND_MASK = 2;
    private static final byte BYTE_FLAG_NULL_MASK = 1;
    private static final int FOUND_VALUE_OFFSET = 1;
    private final boolean replaceWithDefault = NullHandling.replaceWithDefault();
    protected final VectorValueSelector vectorValueSelector;

    public NumericAnyVectorAggregator(VectorValueSelector vectorValueSelector) {
        this.vectorValueSelector = vectorValueSelector;
    }

    abstract void initValue(ByteBuffer var1, int var2);

    abstract boolean putAnyValueFromRow(ByteBuffer var1, int var2, int var3, int var4);

    abstract Object getNonNullObject(ByteBuffer var1, int var2);

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.put(position, this.replaceWithDefault ? (byte)0 : 1);
        this.initValue(buf, position + 1);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        if ((buf.get(position) & 2) != 2) {
            boolean[] nulls = this.vectorValueSelector.getNullVector();
            if (nulls != null) {
                for (int i = startRow; i < endRow && i < nulls.length; ++i) {
                    if (!nulls[i]) continue;
                    this.putNull(buf, position);
                    return;
                }
            }
            if (this.putAnyValueFromRow(buf, position + 1, startRow, endRow)) {
                buf.put(position, (byte)2);
            }
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        for (int i = 0; i < numRows; ++i) {
            int position = positions[i] + positionOffset;
            int row = rows == null ? i : rows[i];
            this.aggregate(buf, position, row, row + 1);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean isNull = this.isValueNull(buf, position);
        return isNull ? null : this.getNonNullObject(buf, position + 1);
    }

    @Override
    public void close() {
    }

    @VisibleForTesting
    boolean isValueNull(ByteBuffer buf, int position) {
        return (buf.get(position) & 1) == 1;
    }

    private void putNull(ByteBuffer buf, int position) {
        if (!this.replaceWithDefault) {
            buf.put(position, (byte)3);
        } else {
            this.initValue(buf, position + 1);
            buf.put(position, (byte)2);
        }
    }
}

