/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.first.NumericFirstVectorAggregator;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatFirstVectorAggregator
extends NumericFirstVectorAggregator {
    public FloatFirstVectorAggregator(VectorValueSelector timeSelector, VectorObjectSelector objectSelector) {
        super(timeSelector, null, objectSelector);
    }

    public FloatFirstVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        super(timeSelector, valueSelector, null);
    }

    @Override
    public void initValue(ByteBuffer buf, int position) {
        buf.putFloat(position, 0.0f);
    }

    @Override
    void putValue(ByteBuffer buf, int position, int index) {
        float firstValue = this.valueSelector != null ? this.valueSelector.getFloatVector()[index] : ((Float)((SerializablePairLongFloat)this.objectSelector.getObjectVector()[index]).getRhs()).floatValue();
        buf.putFloat(position, firstValue);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePairLongFloat(buf.getLong(position), rhsNull ? null : Float.valueOf(buf.getFloat(position + 9)));
    }
}

