/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.NoopAggregator;
import org.apache.druid.query.aggregation.NoopBufferAggregator;
import org.apache.druid.query.aggregation.NoopVectorAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.cardinality.HyperLogLogCollectorAggregateCombiner;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesBufferAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HyperUniquesAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType PRECOMPUTED_TYPE = ColumnType.ofComplex("preComputedHyperUnique");
    public static final ColumnType TYPE = ColumnType.ofComplex("hyperUnique");
    private final String name;
    private final String fieldName;
    private final boolean isInputHyperUnique;
    private final boolean round;

    public static Object estimateCardinality(@Nullable Object object, boolean round) {
        HyperLogLogCollector collector = (HyperLogLogCollector)object;
        if (round) {
            return collector == null ? 0L : collector.estimateCardinalityRound();
        }
        return collector == null ? 0.0 : collector.estimateCardinality();
    }

    @JsonCreator
    public HyperUniquesAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="isInputHyperUnique") boolean isInputHyperUnique, @JsonProperty(value="round") boolean round) {
        this.name = name;
        this.fieldName = fieldName;
        this.isInputHyperUnique = isInputHyperUnique;
        this.round = round;
    }

    public HyperUniquesAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, false, false);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return NoopAggregator.instance();
        }
        Class classOfObject = selector.classOfObject();
        if (classOfObject.equals(Object.class) || HyperLogLogCollector.class.isAssignableFrom(classOfObject)) {
            return new HyperUniquesAggregator(selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a HyperUnique, got a %s", this.fieldName, classOfObject);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector selector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (selector instanceof NilColumnValueSelector) {
            return NoopBufferAggregator.instance();
        }
        Class classOfObject = selector.classOfObject();
        if (classOfObject.equals(Object.class) || HyperLogLogCollector.class.isAssignableFrom(classOfObject)) {
            return new HyperUniquesBufferAggregator(selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a HyperUnique, got a %s", this.fieldName, classOfObject);
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(this.fieldName);
        if (!Types.is(capabilities, ValueType.COMPLEX)) {
            return NoopVectorAggregator.instance();
        }
        return new HyperUniquesVectorAggregator(selectorFactory.makeObjectSelector(this.fieldName));
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public Comparator getComparator() {
        return Comparators.naturalNullsFirst();
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new HyperLogLogCollectorAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name, false, this.round);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public Object deserialize(Object object) {
        ByteBuffer buffer;
        if (object instanceof byte[]) {
            buffer = ByteBuffer.wrap((byte[])object);
        } else if (object instanceof ByteBuffer) {
            buffer = ((ByteBuffer)object).duplicate();
        } else if (object instanceof String) {
            buffer = ByteBuffer.wrap(StringUtils.decodeBase64(StringUtils.toUtf8((String)object)));
        } else {
            return object;
        }
        return HyperLogLogCollector.makeCollector(buffer);
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return HyperUniquesAggregatorFactory.estimateCardinality(object, this.round);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public boolean getIsInputHyperUnique() {
        return this.isInputHyperUnique;
    }

    @JsonProperty
    public boolean isRound() {
        return this.round;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(5).appendString(this.fieldName).appendBoolean(this.round).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return this.isInputHyperUnique ? PRECOMPUTED_TYPE : TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return this.round ? ColumnType.LONG : ColumnType.DOUBLE;
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new HyperUniquesAggregatorFactory(newName, this.getFieldName(), this.getIsInputHyperUnique(), this.isRound());
    }

    public String toString() {
        return "HyperUniquesAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", isInputHyperUnique=" + this.isInputHyperUnique + ", round=" + this.round + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HyperUniquesAggregatorFactory that = (HyperUniquesAggregatorFactory)o;
        return this.isInputHyperUnique == that.isInputHyperUnique && this.round == that.round && Objects.equals(this.name, that.name) && Objects.equals(this.fieldName, that.fieldName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName, this.isInputHyperUnique, this.round);
    }
}

