/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.last.NumericLastVectorAggregator;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleLastVectorAggregator
extends NumericLastVectorAggregator {
    double lastValue = 0.0;

    public DoubleLastVectorAggregator(VectorValueSelector timeSelector, VectorObjectSelector objectSelector) {
        super(timeSelector, null, objectSelector);
    }

    public DoubleLastVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        super(timeSelector, valueSelector, null);
    }

    @Override
    void putValue(ByteBuffer buf, int position, int index) {
        this.lastValue = this.valueSelector != null ? this.valueSelector.getDoubleVector()[index] : (Double)((SerializablePairLongDouble)this.objectSelector.getObjectVector()[index]).getRhs();
        buf.putDouble(position, this.lastValue);
    }

    @Override
    public void initValue(ByteBuffer buf, int position) {
        buf.putDouble(position, 0.0);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePairLongDouble(buf.getLong(position), rhsNull ? null : Double.valueOf(buf.getDouble(position + 9)));
    }
}

