/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.query.aggregation.last.NumericLastVectorAggregator;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongLastVectorAggregator
extends NumericLastVectorAggregator {
    long lastValue = 0L;

    public LongLastVectorAggregator(VectorValueSelector timeSelector, VectorObjectSelector objectSelector) {
        super(timeSelector, null, objectSelector);
    }

    public LongLastVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        super(timeSelector, valueSelector, null);
    }

    @Override
    public void initValue(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    void putValue(ByteBuffer buf, int position, int index) {
        this.lastValue = this.valueSelector != null ? this.valueSelector.getLongVector()[index] : (Long)((SerializablePairLongLong)this.objectSelector.getObjectVector()[index]).getRhs();
        buf.putLong(position, this.lastValue);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePairLongLong(buf.getLong(position), rhsNull ? null : Long.valueOf(buf.getLong(position + 9)));
    }
}

