/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.first.StringFirstLastUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class StringLastBufferAggregator
implements BufferAggregator {
    private static final SerializablePairLongString INIT = new SerializablePairLongString(DateTimes.MIN.getMillis(), null);
    private final BaseLongColumnValueSelector timeSelector;
    private final BaseObjectColumnValueSelector<?> valueSelector;
    private final int maxStringBytes;
    private final boolean needsFoldCheck;

    public StringLastBufferAggregator(BaseLongColumnValueSelector timeSelector, BaseObjectColumnValueSelector<?> valueSelector, int maxStringBytes, boolean needsFoldCheck) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
        this.needsFoldCheck = needsFoldCheck;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        StringFirstLastUtils.writePair(buf, position, INIT, this.maxStringBytes);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        if (this.needsFoldCheck) {
            SerializablePairLongString inPair = StringFirstLastUtils.readPairFromSelectors(this.timeSelector, this.valueSelector);
            if (inPair != null) {
                long lastTime = buf.getLong(position);
                if ((Long)inPair.lhs >= lastTime) {
                    StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString((Long)inPair.lhs, (String)inPair.rhs), this.maxStringBytes);
                }
            }
        } else {
            long lastTime;
            if (this.timeSelector.isNull()) {
                return;
            }
            long time = this.timeSelector.getLong();
            if (time >= (lastTime = buf.getLong(position))) {
                String value = DimensionHandlerUtils.convertObjectToString(this.valueSelector.getObject());
                StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(time, value), this.maxStringBytes);
            }
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return StringFirstLastUtils.readPair(buf, position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getFloat()");
    }

    @Override
    public long getLong(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getLong()");
    }

    @Override
    public double getDouble(ByteBuffer buf, int position) {
        throw new UnsupportedOperationException("StringFirstAggregator does not support getDouble()");
    }

    @Override
    public void close() {
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("timeSelector", this.timeSelector);
        inspector.visit("valueSelector", this.valueSelector);
    }
}

