/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.first.FirstLastUtils;
import org.apache.druid.query.aggregation.first.StringFirstLastUtils;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class StringLastVectorAggregator
implements VectorAggregator {
    private static final SerializablePairLongString INIT = new SerializablePairLongString(DateTimes.MIN.getMillis(), null);
    private final VectorValueSelector timeSelector;
    private final VectorObjectSelector valueSelector;
    private final int maxStringBytes;
    protected long lastTime;

    public StringLastVectorAggregator(@Nullable VectorValueSelector timeSelector, VectorObjectSelector valueSelector, int maxStringBytes) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.maxStringBytes = maxStringBytes;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        StringFirstLastUtils.writePair(buf, position, INIT, this.maxStringBytes);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        if (this.timeSelector == null) {
            return;
        }
        long[] times = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        Object[] objectsWhichMightBeStrings = this.valueSelector.getObjectVector();
        this.lastTime = buf.getLong(position);
        for (int i = endRow - 1; i >= startRow; --i) {
            if (objectsWhichMightBeStrings[i] == null || times[i] <= this.lastTime || nullTimeVector != null && nullTimeVector[i]) continue;
            int index = i;
            boolean foldNeeded = FirstLastUtils.objectNeedsFoldCheck(objectsWhichMightBeStrings[index], SerializablePairLongString.class);
            if (foldNeeded) {
                SerializablePairLongString inPair = StringFirstLastUtils.readPairFromVectorSelectorsAtIndex(this.timeSelector, this.valueSelector, index);
                if (inPair == null) continue;
                long lastTime = buf.getLong(position);
                if ((Long)inPair.lhs < lastTime) continue;
                StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString((Long)inPair.lhs, (String)inPair.rhs), this.maxStringBytes);
                continue;
            }
            long time = times[index];
            if (time < this.lastTime) continue;
            String value = DimensionHandlerUtils.convertObjectToString(objectsWhichMightBeStrings[index]);
            this.lastTime = time;
            StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(time, value), this.maxStringBytes);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        if (this.timeSelector == null) {
            return;
        }
        long[] timeVector = this.timeSelector.getLongVector();
        boolean[] nullTimeVector = this.timeSelector.getNullVector();
        Object[] objectsWhichMightBeStrings = this.valueSelector.getObjectVector();
        boolean foldNeeded = false;
        for (Object obj : objectsWhichMightBeStrings) {
            if (obj == null) continue;
            foldNeeded = FirstLastUtils.objectNeedsFoldCheck(obj, SerializablePairLongString.class);
            break;
        }
        for (int i = 0; i < numRows; ++i) {
            int position;
            long lastTime;
            if (nullTimeVector != null && nullTimeVector[i]) continue;
            int row = rows == null ? i : rows[i];
            if (timeVector[row] < (lastTime = buf.getLong(position = positions[i] + positionOffset))) continue;
            if (foldNeeded) {
                SerializablePairLongString inPair = StringFirstLastUtils.readPairFromVectorSelectorsAtIndex(this.timeSelector, this.valueSelector, row);
                if (inPair == null || (Long)inPair.lhs < lastTime) continue;
                StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString((Long)inPair.lhs, (String)inPair.rhs), this.maxStringBytes);
                continue;
            }
            String value = DimensionHandlerUtils.convertObjectToString(objectsWhichMightBeStrings[row]);
            lastTime = timeVector[row];
            StringFirstLastUtils.writePair(buf, position, new SerializablePairLongString(lastTime, value), this.maxStringBytes);
        }
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        return StringFirstLastUtils.readPair(buf, position);
    }

    @Override
    public void close() {
    }
}

