/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;

class ContainsExpr
extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
    private final Function<String, Boolean> searchFunction;
    private final Expr searchStrExpr;
    private final Function<Expr.Shuttle, Expr> visitFunction;

    ContainsExpr(String functionName, Expr arg, Expr searchStrExpr, boolean caseSensitive, Function<Expr.Shuttle, Expr> visitFunction) {
        this(functionName, arg, searchStrExpr, ContainsExpr.createFunction(searchStrExpr, caseSensitive), visitFunction);
    }

    private ContainsExpr(String functionName, Expr arg, Expr searchStrExpr, Function<String, Boolean> searchFunction, Function<Expr.Shuttle, Expr> visitFunction) {
        super(functionName, arg);
        this.searchFunction = searchFunction;
        this.searchStrExpr = this.validateSearchExpr(searchStrExpr, functionName);
        this.visitFunction = visitFunction;
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        String s = NullHandling.nullToEmptyIfNeeded(this.arg.eval(bindings).asString());
        if (s == null) {
            return ExprEval.ofLongBoolean(false);
        }
        boolean doesContain = this.searchFunction.apply(s);
        return ExprEval.ofLongBoolean(doesContain);
    }

    @Override
    @Nullable
    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
        return ExpressionType.LONG;
    }

    @Override
    public Expr visit(Expr.Shuttle shuttle) {
        return this.visitFunction.apply(shuttle);
    }

    @Override
    public String stringify() {
        return org.apache.druid.java.util.common.StringUtils.format("%s(%s, %s)", this.name, this.arg.stringify(), this.searchStrExpr.stringify());
    }

    private Expr validateSearchExpr(Expr searchExpr, String functioName) {
        if (!ExprUtils.isStringLiteral(searchExpr)) {
            throw new IAE("Function[%s] substring must be a string literal", functioName);
        }
        return searchExpr;
    }

    private static Function<String, Boolean> createFunction(Expr searchStrExpr, boolean caseSensitive) {
        String searchStr = org.apache.druid.java.util.common.StringUtils.nullToEmptyNonDruidDataString((String)searchStrExpr.getLiteralValue());
        if (caseSensitive) {
            return s -> s.contains(searchStr);
        }
        return s -> StringUtils.containsIgnoreCase((String)s, (String)searchStr);
    }
}

