/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.math.expr.vector.CastToTypeVectorProcessor;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.LongOutLongInFunctionVectorValueProcessor;
import org.apache.druid.query.expression.ExprUtils;

public class TimestampFloorExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_floor";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 2, 4);
        if (args.stream().skip(1L).allMatch(Expr::isLiteral)) {
            return new TimestampFloorExpr(args);
        }
        return new TimestampFloorDynamicExpr(args);
    }

    private static PeriodGranularity computeGranularity(List<Expr> args, Expr.ObjectBinding bindings) {
        return ExprUtils.toPeriodGranularity(args.get(1), args.size() > 2 ? args.get(2) : null, args.size() > 3 ? args.get(3) : null, bindings);
    }

    public static class TimestampFloorDynamicExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        TimestampFloorDynamicExpr(List<Expr> args) {
            super(TimestampFloorExprMacro.FN_NAME, args);
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            PeriodGranularity granularity = TimestampFloorExprMacro.computeGranularity(this.args, bindings);
            return ExprEval.of(granularity.bucketStart(((Expr)this.args.get(0)).eval(bindings).asLong()));
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            return shuttle.visit(new TimestampFloorDynamicExpr(shuttle.visitAll(this.args)));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }
    }

    public static class TimestampFloorExpr
    extends ExprMacroTable.BaseScalarMacroFunctionExpr {
        private final PeriodGranularity granularity;

        TimestampFloorExpr(List<Expr> args) {
            super(TimestampFloorExprMacro.FN_NAME, args);
            this.granularity = TimestampFloorExprMacro.computeGranularity(args, InputBindings.nilBindings());
        }

        public Expr getArg() {
            return (Expr)this.args.get(0);
        }

        public PeriodGranularity getGranularity() {
            return this.granularity;
        }

        @Override
        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            ExprEval eval = ((Expr)this.args.get(0)).eval(bindings);
            if (eval.isNumericNull()) {
                return ExprEval.of(null);
            }
            return ExprEval.of(this.granularity.bucketStart(eval.asLong()));
        }

        @Override
        public Expr visit(Expr.Shuttle shuttle) {
            return shuttle.visit(new TimestampFloorExpr(shuttle.visitAll(this.args)));
        }

        @Override
        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.LONG;
        }

        @Override
        public boolean canVectorize(Expr.InputBindingInspector inspector) {
            return ((Expr)this.args.get(0)).canVectorize(inspector);
        }

        @Override
        public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
            LongOutLongInFunctionVectorValueProcessor processor = new LongOutLongInFunctionVectorValueProcessor(CastToTypeVectorProcessor.cast(((Expr)this.args.get(0)).asVectorProcessor(inspector), ExpressionType.LONG), inspector.getMaxVectorSize()){

                @Override
                public long apply(long input) {
                    return granularity.bucketStart(input);
                }
            };
            return processor;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TimestampFloorExpr that = (TimestampFloorExpr)o;
            return Objects.equals(this.granularity, that.granularity);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.granularity);
        }
    }
}

