/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RangeSet;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.AbstractOptimizableDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.segment.filter.JavaScriptFilter;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptDimFilter
extends AbstractOptimizableDimFilter
implements DimFilter {
    private final String dimension;
    private final String function;
    @Nullable
    private final ExtractionFn extractionFn;
    @Nullable
    private final FilterTuning filterTuning;
    private final JavaScriptConfig config;
    private volatile @MonotonicNonNull JavaScriptPredicateFactory predicateFactory;

    @JsonCreator
    public JavaScriptDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="function") String function, @JsonProperty(value="extractionFn") @Nullable ExtractionFn extractionFn, @JsonProperty(value="filterTuning") @Nullable FilterTuning filterTuning, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function must not be null");
        this.dimension = dimension;
        this.function = function;
        this.extractionFn = extractionFn;
        this.filterTuning = filterTuning;
        this.config = config;
    }

    @VisibleForTesting
    public JavaScriptDimFilter(String dimension, String function, @Nullable ExtractionFn extractionFn, JavaScriptConfig config) {
        this(dimension, function, extractionFn, null, config);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @Nullable
    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    public FilterTuning getFilterTuning() {
        return this.filterTuning;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8(this.dimension);
        byte[] functionBytes = StringUtils.toUtf8(this.function);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + functionBytes.length + extractionFnBytes.length).put((byte)7).put(dimensionBytes).put((byte)-1).put(functionBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public Filter toFilter() {
        JavaScriptPredicateFactory predicateFactory = this.getPredicateFactory();
        return new JavaScriptFilter(this.dimension, predicateFactory, this.filterTuning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"predicateFactory"})
    @VisibleForTesting
    JavaScriptPredicateFactory getPredicateFactory() {
        Preconditions.checkState((boolean)this.config.isEnabled(), (Object)"JavaScript is disabled");
        JavaScriptPredicateFactory syncedFnPredicateFactory = this.predicateFactory;
        if (syncedFnPredicateFactory == null) {
            JavaScriptConfig javaScriptConfig = this.config;
            synchronized (javaScriptConfig) {
                syncedFnPredicateFactory = this.predicateFactory;
                if (syncedFnPredicateFactory == null) {
                    this.predicateFactory = syncedFnPredicateFactory = new JavaScriptPredicateFactory(this.function, this.extractionFn);
                }
            }
        }
        return syncedFnPredicateFactory;
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        return null;
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptDimFilter that = (JavaScriptDimFilter)o;
        return this.dimension.equals(that.dimension) && this.function.equals(that.function) && Objects.equals(this.extractionFn, that.extractionFn) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.function, this.extractionFn, this.filterTuning);
    }

    public String toString() {
        return "JavaScriptDimFilter{dimension='" + this.dimension + '\'' + ", function='" + this.function + '\'' + ", extractionFn=" + this.extractionFn + ", filterTuning=" + this.filterTuning + '}';
    }

    public static class JavaScriptPredicateFactory
    implements DruidPredicateFactory {
        final ScriptableObject scope;
        final Function fnApply;
        final String script;
        final ExtractionFn extractionFn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaScriptPredicateFactory(String script, ExtractionFn extractionFn) {
            Preconditions.checkNotNull((Object)script, (Object)"script must not be null");
            this.script = script;
            this.extractionFn = extractionFn;
            Context cx = Context.enter();
            try {
                cx.setOptimizationLevel(9);
                this.scope = cx.initStandardObjects();
                this.fnApply = cx.compileFunction((Scriptable)this.scope, script, "script", 1, null);
            }
            finally {
                Context.exit();
            }
        }

        @Override
        public DruidObjectPredicate<String> makeStringPredicate() {
            return this::applyObject;
        }

        @Override
        public DruidLongPredicate makeLongPredicate() {
            return new DruidLongPredicate(){

                @Override
                public DruidPredicateMatch applyLong(long input) {
                    return this.applyObject(input);
                }

                @Override
                public DruidPredicateMatch applyNull() {
                    return this.applyObject(null);
                }
            };
        }

        @Override
        public DruidFloatPredicate makeFloatPredicate() {
            return new DruidFloatPredicate(){

                @Override
                public DruidPredicateMatch applyFloat(float input) {
                    return this.applyObject(Float.valueOf(input));
                }

                @Override
                public DruidPredicateMatch applyNull() {
                    return this.applyObject(null);
                }
            };
        }

        @Override
        public DruidDoublePredicate makeDoublePredicate() {
            return new DruidDoublePredicate(){

                @Override
                public DruidPredicateMatch applyDouble(double input) {
                    return this.applyObject(input);
                }

                @Override
                public DruidPredicateMatch applyNull() {
                    return this.applyObject(null);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DruidPredicateMatch applyObject(Object input) {
            Context cx = Context.enter();
            try {
                DruidPredicateMatch druidPredicateMatch = DruidPredicateMatch.of(this.applyInContext(cx, input));
                return druidPredicateMatch;
            }
            finally {
                Context.exit();
            }
        }

        public boolean applyInContext(Context cx, Object input) {
            Object fnResult;
            if (this.extractionFn != null) {
                input = this.extractionFn.apply(input);
            }
            if ((fnResult = this.fnApply.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, new Object[]{input})) instanceof ScriptableObject) {
                return Context.toBoolean((Object)((ScriptableObject)fnResult).getDefaultValue(ScriptRuntime.BooleanClass));
            }
            return Context.toBoolean((Object)fnResult);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaScriptPredicateFactory that = (JavaScriptPredicateFactory)o;
            return this.script.equals(that.script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }
}

