/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByQueryQueryToolChest;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;

public class GroupByQueryRunnerFactory
implements QueryRunnerFactory<ResultRow, GroupByQuery> {
    private final GroupingEngine groupingEngine;
    private final GroupByQueryQueryToolChest toolChest;

    @Inject
    public GroupByQueryRunnerFactory(GroupingEngine groupingEngine, GroupByQueryQueryToolChest toolChest) {
        this.groupingEngine = groupingEngine;
        this.toolChest = toolChest;
    }

    @Override
    public QueryRunner<ResultRow> createRunner(Segment segment) {
        return new GroupByQueryRunner(segment, this.groupingEngine);
    }

    @Override
    public QueryRunner<ResultRow> mergeRunners(final QueryProcessingPool queryProcessingPool, final Iterable<QueryRunner<ResultRow>> queryRunners) {
        return new QueryRunner<ResultRow>(){

            @Override
            public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
                QueryRunner<ResultRow> rowQueryRunner = GroupByQueryRunnerFactory.this.groupingEngine.mergeRunners(queryProcessingPool, queryRunners);
                return rowQueryRunner.run(queryPlus, responseContext);
            }
        };
    }

    @Override
    public QueryToolChest<ResultRow, GroupByQuery> getToolchest() {
        return this.toolChest;
    }

    @VisibleForTesting
    public GroupingEngine getGroupingEngine() {
        return this.groupingEngine;
    }

    private static class GroupByQueryRunner
    implements QueryRunner<ResultRow> {
        private final StorageAdapter adapter;
        private final GroupingEngine groupingEngine;

        public GroupByQueryRunner(Segment segment, GroupingEngine groupingEngine) {
            this.adapter = segment.asStorageAdapter();
            this.groupingEngine = groupingEngine;
        }

        @Override
        public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, ResponseContext responseContext) {
            Query<ResultRow> query = queryPlus.getQuery();
            if (!(query instanceof GroupByQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", query.getClass(), GroupByQuery.class);
            }
            return this.groupingEngine.process((GroupByQuery)query, this.adapter, (GroupByQueryMetrics)queryPlus.getQueryMetrics());
        }
    }
}

