/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.DefaultClusteredGroupPartitioner;

public class NaivePartitioningOperator
implements Operator {
    private final List<String> partitionColumns;
    private final Operator child;

    public NaivePartitioningOperator(List<String> partitionColumns, Operator child) {
        this.partitionColumns = partitionColumns;
        this.child = child;
    }

    @Override
    public Closeable goOrContinue(Closeable continuation, final Operator.Receiver receiver) {
        if (continuation != null) {
            Continuation cont = (Continuation)continuation;
            if (cont.iter != null) {
                block7: while (cont.iter.hasNext()) {
                    Operator.Signal signal = receiver.push(cont.iter.next());
                    switch (signal) {
                        case GO: {
                            continue block7;
                        }
                        case PAUSE: {
                            if (cont.iter.hasNext()) {
                                return cont;
                            }
                            if (cont.subContinuation == null) {
                                receiver.completed();
                                return null;
                            }
                            return new Continuation(null, cont.subContinuation);
                        }
                        case STOP: {
                            receiver.completed();
                            try {
                                cont.close();
                            }
                            catch (IOException e) {
                                throw new RE(e, "Unable to close continutation", new Object[0]);
                            }
                            return null;
                        }
                    }
                    throw new RE("Unknown signal[%s]", new Object[]{signal});
                }
                if (cont.subContinuation == null) {
                    receiver.completed();
                    return null;
                }
            }
            continuation = cont.subContinuation;
        }
        final AtomicReference iterHolder = new AtomicReference();
        Closeable retVal = this.child.goOrContinue(continuation, new Operator.Receiver(){

            @Override
            public Operator.Signal push(RowsAndColumns rac) {
                if (rac == null) {
                    throw DruidException.defensive("Should never get a null rac here.", new Object[0]);
                }
                ClusteredGroupPartitioner groupPartitioner = rac.as(ClusteredGroupPartitioner.class);
                if (groupPartitioner == null) {
                    groupPartitioner = new DefaultClusteredGroupPartitioner(rac);
                }
                Iterator<RowsAndColumns> partitionsIter = groupPartitioner.partitionOnBoundaries(NaivePartitioningOperator.this.partitionColumns).iterator();
                Operator.Signal keepItGoing = Operator.Signal.GO;
                while (keepItGoing == Operator.Signal.GO && partitionsIter.hasNext()) {
                    keepItGoing = receiver.push(partitionsIter.next());
                }
                if (keepItGoing == Operator.Signal.PAUSE && partitionsIter.hasNext()) {
                    iterHolder.set(partitionsIter);
                    return Operator.Signal.PAUSE;
                }
                return keepItGoing;
            }

            @Override
            public void completed() {
                if (iterHolder.get() == null) {
                    receiver.completed();
                }
            }
        });
        if (iterHolder.get() != null || retVal != null) {
            return new Continuation((Iterator)iterHolder.get(), retVal);
        }
        return null;
    }

    private static class Continuation
    implements Closeable {
        Iterator<RowsAndColumns> iter;
        Closeable subContinuation;

        public Continuation(Iterator<RowsAndColumns> iter, Closeable subContinuation) {
            this.iter = iter;
            this.subContinuation = subContinuation;
        }

        @Override
        public void close() throws IOException {
            if (this.subContinuation != null) {
                this.subContinuation.close();
            }
        }
    }
}

