/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.rowsandcols.RowsAndColumns;

public class ComposingProcessor
implements Processor {
    private final Processor[] processors;

    @JsonCreator
    public ComposingProcessor(Processor ... processors) {
        this.processors = processors;
    }

    @JsonProperty(value="processors")
    public Processor[] getProcessors() {
        return this.processors;
    }

    @Override
    public RowsAndColumns process(RowsAndColumns incomingPartition) {
        RowsAndColumns retVal = incomingPartition;
        for (int i = this.processors.length - 1; i >= 0; --i) {
            retVal = this.processors[i].process(retVal);
        }
        return retVal;
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        if (otherProcessor instanceof ComposingProcessor) {
            ComposingProcessor other = (ComposingProcessor)otherProcessor;
            for (int i = 0; i < this.processors.length; ++i) {
                if (this.processors[i].validateEquivalent(other.processors[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "ComposingProcessor{processors=" + Arrays.toString(this.processors) + '}';
    }
}

