/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.query.operator.ColumnWithDirection;

public class WindowFrame {
    private final PeerType peerType;
    private final boolean lowerUnbounded;
    private final int lowerOffset;
    private final boolean upperUnbounded;
    private final int upperOffset;
    private final List<ColumnWithDirection> orderBy;

    public static WindowFrame unbounded() {
        return new WindowFrame(PeerType.ROWS, true, 0, true, 0, null);
    }

    @JsonCreator
    public WindowFrame(@JsonProperty(value="peerType") PeerType peerType, @JsonProperty(value="lowUnbounded") boolean lowerUnbounded, @JsonProperty(value="lowOffset") int lowerOffset, @JsonProperty(value="uppUnbounded") boolean upperUnbounded, @JsonProperty(value="uppOffset") int upperOffset, @JsonProperty(value="orderBy") List<ColumnWithDirection> orderBy) {
        this.peerType = peerType;
        this.lowerUnbounded = lowerUnbounded;
        this.lowerOffset = lowerOffset;
        this.upperUnbounded = upperUnbounded;
        this.upperOffset = upperOffset;
        this.orderBy = orderBy;
    }

    @JsonProperty(value="peerType")
    public PeerType getPeerType() {
        return this.peerType;
    }

    @JsonProperty(value="lowUnbounded")
    public boolean isLowerUnbounded() {
        return this.lowerUnbounded;
    }

    @JsonProperty(value="lowOffset")
    public int getLowerOffset() {
        return this.lowerOffset;
    }

    @JsonProperty(value="uppUnbounded")
    public boolean isUpperUnbounded() {
        return this.upperUnbounded;
    }

    @JsonProperty(value="uppOffset")
    public int getUpperOffset() {
        return this.upperOffset;
    }

    @JsonProperty(value="orderBy")
    public List<ColumnWithDirection> getOrderBy() {
        return this.orderBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WindowFrame)) {
            return false;
        }
        WindowFrame that = (WindowFrame)o;
        return this.lowerUnbounded == that.lowerUnbounded && this.lowerOffset == that.lowerOffset && this.upperUnbounded == that.upperUnbounded && this.upperOffset == that.upperOffset && this.peerType == that.peerType && Objects.equals(this.orderBy, that.orderBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.peerType, this.lowerUnbounded, this.lowerOffset, this.upperUnbounded, this.upperOffset, this.orderBy});
    }

    public String toString() {
        return "WindowFrame{peerType=" + (Object)((Object)this.peerType) + ", lowerUnbounded=" + this.lowerUnbounded + ", lowerOffset=" + this.lowerOffset + ", upperUnbounded=" + this.upperUnbounded + ", upperOffset=" + this.upperOffset + ", orderBy=" + this.orderBy + '}';
    }

    public static WindowFrame forOrderBy(ColumnWithDirection ... orderBy) {
        return new WindowFrame(PeerType.RANGE, true, 0, false, 0, Lists.newArrayList((Object[])orderBy));
    }

    public List<String> getOrderByColNames() {
        if (this.orderBy == null) {
            return Collections.emptyList();
        }
        return this.orderBy.stream().map(ColumnWithDirection::getColumn).collect(Collectors.toList());
    }

    public int getLowerOffsetClamped(int maxRows) {
        if (this.lowerUnbounded) {
            return maxRows;
        }
        return Math.min(maxRows, this.lowerOffset);
    }

    public int getUpperOffsetClamped(int maxRows) {
        if (this.upperUnbounded) {
            return maxRows;
        }
        return Math.min(maxRows, this.upperOffset);
    }

    public static enum PeerType {
        ROWS,
        RANGE;

    }
}

