/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.LimitedColumn;

public class LimitedRowsAndColumns
implements RowsAndColumns {
    private final RowsAndColumns rac;
    private final int start;
    private final int end;

    public LimitedRowsAndColumns(RowsAndColumns rac, int start, int end) {
        int numRows = rac.numRows();
        if (numRows < end) {
            throw new ISE("end[%d] is out of bounds, cannot be greater than numRows[%d]", end, numRows);
        }
        this.rac = rac;
        this.start = start;
        this.end = end;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.rac.getColumnNames();
    }

    @Override
    public int numRows() {
        return this.end - this.start;
    }

    @Override
    public Column findColumn(String name) {
        Column column = this.rac.findColumn(name);
        if (column == null) {
            return null;
        }
        return new LimitedColumn(column, this.start, this.end);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        return null;
    }
}

