/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnValueSwapper;
import org.apache.druid.query.rowsandcols.column.VectorCopier;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ColumnType;

public class DoubleArrayColumn
implements Column {
    private final double[] vals;

    public DoubleArrayColumn(double[] vals) {
        this.vals = vals;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        return new MyColumnAccessor();
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        if (VectorCopier.class.equals(clazz)) {
            return (T)((VectorCopier)(into, intoStart) -> {
                if (Integer.MAX_VALUE - this.vals.length < intoStart) {
                    throw new ISE("too many rows!!! intoStart[%,d], vals.length[%,d] combine to exceed max_int", intoStart, this.vals.length);
                }
                for (int i = 0; i < this.vals.length; ++i) {
                    into[intoStart + i] = this.vals[i];
                }
            });
        }
        if (ColumnValueSwapper.class.equals(clazz)) {
            return (T)((ColumnValueSwapper)(lhs, rhs) -> {
                double tmp = this.vals[lhs];
                this.vals[lhs] = this.vals[rhs];
                this.vals[rhs] = tmp;
            });
        }
        return null;
    }

    private class MyColumnAccessor
    implements BinarySearchableAccessor {
        private MyColumnAccessor() {
        }

        @Override
        public ColumnType getType() {
            return ColumnType.DOUBLE;
        }

        @Override
        public int numRows() {
            return DoubleArrayColumn.this.vals.length;
        }

        @Override
        public boolean isNull(int rowNum) {
            return false;
        }

        @Override
        public Object getObject(int rowNum) {
            return DoubleArrayColumn.this.vals[rowNum];
        }

        @Override
        public double getDouble(int rowNum) {
            return DoubleArrayColumn.this.vals[rowNum];
        }

        @Override
        public float getFloat(int rowNum) {
            return (float)DoubleArrayColumn.this.vals[rowNum];
        }

        @Override
        public long getLong(int rowNum) {
            return (long)DoubleArrayColumn.this.vals[rowNum];
        }

        @Override
        public int getInt(int rowNum) {
            return (int)DoubleArrayColumn.this.vals[rowNum];
        }

        @Override
        public int compareRows(int lhsRowNum, int rhsRowNum) {
            return Double.compare(lhsRowNum, rhsRowNum);
        }

        @Override
        public FindResult findNull(int startIndex, int endIndex) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findDouble(int startIndex, int endIndex, double val) {
            if (DoubleArrayColumn.this.vals[startIndex] == val) {
                int end;
                for (end = startIndex + 1; end < endIndex && DoubleArrayColumn.this.vals[end] == val; ++end) {
                }
                return FindResult.found(startIndex, end);
            }
            int i = Arrays.binarySearch(DoubleArrayColumn.this.vals, startIndex, endIndex, val);
            if (i > 0) {
                int foundStart = i;
                int foundEnd = i + 1;
                while (foundStart - 1 >= startIndex && DoubleArrayColumn.this.vals[foundStart - 1] == val) {
                    --foundStart;
                }
                while (foundEnd < endIndex && DoubleArrayColumn.this.vals[foundEnd] == val) {
                    ++foundEnd;
                }
                return FindResult.found(foundStart, foundEnd);
            }
            return FindResult.notFound(-(i + 1));
        }

        @Override
        public FindResult findFloat(int startIndex, int endIndex, float val) {
            return this.findDouble(startIndex, endIndex, val);
        }

        @Override
        public FindResult findLong(int startIndex, int endIndex, long val) {
            return this.findDouble(startIndex, endIndex, val);
        }

        @Override
        public FindResult findString(int startIndex, int endIndex, String val) {
            return this.findDouble(startIndex, endIndex, Numbers.tryParseDouble(val, 0.0));
        }

        @Override
        public FindResult findComplex(int startIndex, int endIndex, Object val) {
            return this.findDouble(startIndex, endIndex, Numbers.tryParseDouble(val, 0.0));
        }
    }
}

