/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.ColumnHolderRACColumn;
import org.apache.druid.segment.CloseableShapeshifter;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.column.ColumnHolder;

public class QueryableIndexRowsAndColumns
implements RowsAndColumns,
AutoCloseable,
CloseableShapeshifter {
    private static final HashMap<Class<?>, Function<QueryableIndexRowsAndColumns, ?>> AS_MAP = QueryableIndexRowsAndColumns.makeAsMap();
    private final QueryableIndex index;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Closer closer = Closer.create();
    private final AtomicInteger numRows = new AtomicInteger(-1);

    public QueryableIndexRowsAndColumns(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.index.getColumnNames();
    }

    @Override
    public int numRows() {
        int retVal = this.numRows.get();
        if (retVal < 0) {
            retVal = this.index.getNumRows();
            this.numRows.set(retVal);
        }
        return retVal;
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (this.closed.get()) {
            throw DruidException.defensive("Cannot be accessed after being closed!?", new Object[0]);
        }
        ColumnHolder columnHolder = this.index.getColumnHolder(name);
        if (columnHolder == null) {
            return null;
        }
        return this.closer.register(new ColumnHolderRACColumn(columnHolder));
    }

    @Override
    @Nullable
    public <T> T as(@Nonnull Class<T> clazz) {
        return (T)AS_MAP.getOrDefault(clazz, arg -> null).apply(this);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.closer.close();
        }
    }

    private static HashMap<Class<?>, Function<QueryableIndexRowsAndColumns, ?>> makeAsMap() {
        HashMap retVal = new HashMap();
        retVal.put(StorageAdapter.class, rac -> new QueryableIndexStorageAdapter(rac.index));
        retVal.put(QueryableIndex.class, rac -> rac.index);
        return retVal;
    }
}

