/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.semantic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.operator.window.WindowFrame;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.ConstantObjectColumn;
import org.apache.druid.query.rowsandcols.column.ObjectArrayColumn;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ClusteredGroupPartitioner;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.query.rowsandcols.semantic.FramedOnHeapAggregatable;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.ObjectBasedColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;

public class DefaultFramedOnHeapAggregatable
implements FramedOnHeapAggregatable {
    private final AppendableRowsAndColumns rac;

    public DefaultFramedOnHeapAggregatable(AppendableRowsAndColumns rac) {
        this.rac = rac;
    }

    @Override
    @Nonnull
    public RowsAndColumns aggregateAll(WindowFrame frame, AggregatorFactory[] aggFactories) {
        if (frame.isLowerUnbounded() && frame.isUpperUnbounded()) {
            return this.computeUnboundedAggregates(aggFactories);
        }
        if (frame.getPeerType() == WindowFrame.PeerType.ROWS) {
            int upperOffset;
            int lowerOffset;
            if (frame.isLowerUnbounded()) {
                return this.computeCumulativeAggregates(aggFactories, frame.getUpperOffset());
            }
            if (frame.isUpperUnbounded()) {
                return this.computeReverseCumulativeAggregates(aggFactories, frame.getLowerOffset());
            }
            int numRows = this.rac.numRows();
            if (numRows < (lowerOffset = frame.getLowerOffset()) + (upperOffset = frame.getUpperOffset()) + 1) {
                return this.aggregateWindowApertureInFlux(aggFactories, lowerOffset, upperOffset);
            }
            return this.aggregateWindowApertureWellBehaved(aggFactories, lowerOffset, upperOffset);
        }
        return this.computeGroupAggregates(aggFactories, frame);
    }

    private RowsAndColumns computeGroupAggregates(AggregatorFactory[] aggFactories, WindowFrame frame) {
        Iterable<AggInterval> groupIterator = DefaultFramedOnHeapAggregatable.buildGroupIteratorFor(this.rac, frame);
        ResultPopulator resultRac = new ResultPopulator(aggFactories, this.rac.numRows());
        AggIntervalCursor aggCursor = new AggIntervalCursor(this.rac, aggFactories);
        for (AggInterval aggInterval : groupIterator) {
            aggCursor.moveTo(aggInterval.inputRows);
            resultRac.write(aggInterval.outputRows, aggCursor);
        }
        resultRac.appendTo(this.rac);
        return this.rac;
    }

    public static Iterable<AggInterval> buildGroupIteratorFor(AppendableRowsAndColumns rac, WindowFrame frame) {
        int[] groupBoundaries = ClusteredGroupPartitioner.fromRAC(rac).computeBoundaries(frame.getOrderByColNames());
        return new GroupIteratorForWindowFrame(frame, groupBoundaries);
    }

    @VisibleForTesting
    public static int invertedOrderForLastK(int x, int n, int k) {
        Preconditions.checkState((k <= n ? 1 : 0) != 0);
        if (k <= 1 || x + k < n) {
            return x;
        }
        int i = x - (n - k);
        return n - 1 - i;
    }

    public static Object cloneAggValue(AggregatorFactory aggFactory, Object value) {
        if (value == null || value instanceof Number) {
            return value;
        }
        Object[] currentValue = new Object[]{value};
        CumulativeColumnSelectorFactory combiningFactory = new CumulativeColumnSelectorFactory(aggFactory, currentValue, 0);
        Aggregator combiningAgg = aggFactory.getCombiningFactory().factorize(combiningFactory);
        combiningAgg.aggregate();
        return combiningAgg.get();
    }

    private AppendableRowsAndColumns computeUnboundedAggregates(AggregatorFactory[] aggFactories) {
        Aggregator[] aggs = new Aggregator[aggFactories.length];
        AtomicInteger currRow = new AtomicInteger(0);
        ColumnSelectorFactory columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(this.rac).make(currRow);
        for (int i = 0; i < aggFactories.length; ++i) {
            aggs[i] = aggFactories[i].factorize(columnSelectorFactory);
        }
        int numRows = this.rac.numRows();
        int rowId = currRow.get();
        while (rowId < numRows) {
            for (Aggregator agg : aggs) {
                agg.aggregate();
            }
            rowId = currRow.incrementAndGet();
        }
        for (int i = 0; i < aggFactories.length; ++i) {
            this.rac.addColumn(aggFactories[i].getName(), new ConstantObjectColumn(aggs[i].get(), numRows, aggFactories[i].getIntermediateType()));
            aggs[i].close();
        }
        return this.rac;
    }

    private AppendableRowsAndColumns computeCumulativeAggregates(AggregatorFactory[] aggFactories, int upperOffset) {
        int i;
        int numRows = this.rac.numRows();
        if (upperOffset > numRows) {
            return this.computeUnboundedAggregates(aggFactories);
        }
        Object[][] results = new Object[aggFactories.length][numRows];
        int resultStorageIndex = 0;
        AtomicInteger rowIdProvider = new AtomicInteger(0);
        ColumnSelectorFactory columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(this.rac).make(rowIdProvider);
        AggregatorFactory[] combiningFactories = new AggregatorFactory[aggFactories.length];
        Aggregator[] aggs = new Aggregator[aggFactories.length];
        for (i = 0; i < aggFactories.length; ++i) {
            combiningFactories[i] = aggFactories[i].getCombiningFactory();
            aggs[i] = aggFactories[i].factorize(columnSelectorFactory);
        }
        for (i = 0; i < upperOffset; ++i) {
            Aggregator[] aggregatorArray = aggs;
            int n = aggregatorArray.length;
            for (int j = 0; j < n; ++j) {
                Aggregator agg = aggregatorArray[j];
                agg.aggregate();
            }
            rowIdProvider.incrementAndGet();
        }
        if (rowIdProvider.get() < numRows) {
            for (i = 0; i < aggs.length; ++i) {
                aggs[i].aggregate();
                results[i][resultStorageIndex] = aggs[i].get();
                aggs[i].close();
                aggs[i] = aggFactories[i].factorize(columnSelectorFactory);
            }
            ++resultStorageIndex;
            rowIdProvider.incrementAndGet();
        }
        for (int rowId = rowIdProvider.get(); rowId < numRows; ++rowId) {
            for (int i2 = 0; i2 < aggs.length; ++i2) {
                aggs[i2].aggregate();
                results[i2][resultStorageIndex] = aggs[i2].get();
                aggs[i2].close();
                CumulativeColumnSelectorFactory combiningFactory = new CumulativeColumnSelectorFactory(aggFactories[i2], results[i2], resultStorageIndex - 1);
                Aggregator combiningAgg = combiningFactories[i2].factorize(combiningFactory);
                combiningAgg.aggregate();
                combiningFactory.increment();
                combiningAgg.aggregate();
                results[i2][resultStorageIndex] = combiningAgg.get();
                combiningAgg.close();
                aggs[i2] = aggFactories[i2].factorize(columnSelectorFactory);
            }
            ++resultStorageIndex;
            rowIdProvider.incrementAndGet();
        }
        for (Object[] resultArr : results) {
            Arrays.fill(resultArr, resultStorageIndex, resultArr.length, resultArr[resultStorageIndex - 1]);
        }
        return this.makeReturnRAC(aggFactories, results);
    }

    private AppendableRowsAndColumns computeReverseCumulativeAggregates(AggregatorFactory[] aggFactories, int lowerOffset) {
        int i;
        int numRows = this.rac.numRows();
        if (lowerOffset > numRows) {
            return this.computeUnboundedAggregates(aggFactories);
        }
        Object[][] results = new Object[aggFactories.length][numRows];
        int resultStorageIndex = numRows - 1;
        AtomicInteger rowIdProvider = new AtomicInteger(numRows - 1);
        ColumnSelectorFactory columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(this.rac).make(rowIdProvider);
        AggregatorFactory[] combiningFactories = new AggregatorFactory[aggFactories.length];
        Aggregator[] aggs = new Aggregator[aggFactories.length];
        for (i = 0; i < aggFactories.length; ++i) {
            combiningFactories[i] = aggFactories[i].getCombiningFactory();
            aggs[i] = aggFactories[i].factorize(columnSelectorFactory);
        }
        for (i = 0; i < lowerOffset; ++i) {
            Aggregator[] aggregatorArray = aggs;
            int n = aggregatorArray.length;
            for (int j = 0; j < n; ++j) {
                Aggregator agg = aggregatorArray[j];
                agg.aggregate();
            }
            rowIdProvider.decrementAndGet();
        }
        if (rowIdProvider.get() >= 0) {
            for (i = 0; i < aggs.length; ++i) {
                aggs[i].aggregate();
                results[i][resultStorageIndex] = aggs[i].get();
                aggs[i].close();
                aggs[i] = aggFactories[i].factorize(columnSelectorFactory);
            }
            --resultStorageIndex;
            rowIdProvider.decrementAndGet();
        }
        for (int rowId = rowIdProvider.get(); rowId >= 0; --rowId) {
            for (int i2 = 0; i2 < aggs.length; ++i2) {
                aggs[i2].aggregate();
                results[i2][resultStorageIndex] = aggs[i2].get();
                aggs[i2].close();
                CumulativeColumnSelectorFactory combiningFactory = new CumulativeColumnSelectorFactory(aggFactories[i2], results[i2], resultStorageIndex + 1);
                Aggregator combiningAgg = combiningFactories[i2].factorize(combiningFactory);
                combiningAgg.aggregate();
                combiningFactory.decrement();
                combiningAgg.aggregate();
                results[i2][resultStorageIndex] = combiningAgg.get();
                combiningAgg.close();
                aggs[i2] = aggFactories[i2].factorize(columnSelectorFactory);
            }
            --resultStorageIndex;
            rowIdProvider.decrementAndGet();
        }
        for (Object[] resultArr : results) {
            Arrays.fill(resultArr, 0, resultStorageIndex + 1, resultArr[resultStorageIndex + 1]);
        }
        return this.makeReturnRAC(aggFactories, results);
    }

    private AppendableRowsAndColumns aggregateWindowApertureWellBehaved(AggregatorFactory[] aggFactories, int lowerOffset, int upperOffset) {
        int i;
        int j;
        int numRows = this.rac.numRows();
        int windowSize = lowerOffset + upperOffset + 1;
        Object[][] results = new Object[aggFactories.length][numRows];
        int resultStorageIndex = 0;
        AtomicInteger rowIdProvider = new AtomicInteger(0);
        ColumnSelectorFactory columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(this.rac).make(rowIdProvider);
        int nextIndex = lowerOffset + 1;
        Aggregator[][] aggregators = new Aggregator[aggFactories.length][windowSize];
        for (int i2 = 0; i2 < aggregators.length; ++i2) {
            AggregatorFactory aggFactory = aggFactories[i2];
            for (j = 0; j < nextIndex; ++j) {
                aggregators[i2][j] = aggFactory.factorize(columnSelectorFactory);
            }
        }
        for (int upperIndex = 0; upperIndex < upperOffset; ++upperIndex) {
            for (Aggregator[] aggregator : aggregators) {
                for (int j2 = 0; j2 < nextIndex; ++j2) {
                    aggregator[j2].aggregate();
                }
            }
            for (int i3 = 0; i3 < aggFactories.length; ++i3) {
                aggregators[i3][nextIndex] = aggFactories[i3].factorize(columnSelectorFactory);
            }
            ++nextIndex;
            rowIdProvider.incrementAndGet();
        }
        int endResultStorageIndex = numRows - windowSize;
        while (resultStorageIndex < endResultStorageIndex) {
            Aggregator[][] i3 = aggregators;
            j = i3.length;
            for (int k = 0; k < j; ++k) {
                Aggregator[] aggregator;
                for (Aggregator value : aggregator = i3[k]) {
                    value.aggregate();
                }
            }
            if (nextIndex == windowSize) {
                nextIndex = 0;
            }
            for (int i4 = 0; i4 < aggFactories.length; ++i4) {
                results[i4][resultStorageIndex] = aggregators[i4][nextIndex].get();
                aggregators[i4][nextIndex].close();
                aggregators[i4][nextIndex] = aggFactories[i4].factorize(columnSelectorFactory);
            }
            ++nextIndex;
            rowIdProvider.incrementAndGet();
            ++resultStorageIndex;
        }
        if (nextIndex == windowSize) {
            nextIndex = 0;
        }
        if (nextIndex != 0) {
            Aggregator[][] reorganizedAggs = new Aggregator[aggFactories.length][windowSize];
            for (i = 0; i < aggFactories.length; ++i) {
                System.arraycopy(aggregators[i], nextIndex, reorganizedAggs[i], 0, windowSize - nextIndex);
                System.arraycopy(aggregators[i], 0, reorganizedAggs[i], windowSize - nextIndex, nextIndex);
            }
            aggregators = reorganizedAggs;
            nextIndex = 0;
        }
        for (int rowId = rowIdProvider.get(); rowId < numRows; ++rowId) {
            for (Aggregator[] aggregator : aggregators) {
                for (int j3 = nextIndex; j3 < aggregator.length; ++j3) {
                    aggregator[j3].aggregate();
                }
            }
            for (i = 0; i < aggFactories.length; ++i) {
                results[i][resultStorageIndex] = aggregators[i][nextIndex].get();
                aggregators[i][nextIndex].close();
                aggregators[i][nextIndex] = null;
            }
            ++nextIndex;
            ++resultStorageIndex;
            rowIdProvider.incrementAndGet();
        }
        while (nextIndex < windowSize) {
            for (int i5 = 0; i5 < aggFactories.length; ++i5) {
                results[i5][resultStorageIndex] = aggregators[i5][nextIndex].get();
                aggregators[i5][nextIndex] = null;
            }
            ++resultStorageIndex;
            ++nextIndex;
        }
        return this.makeReturnRAC(aggFactories, results);
    }

    private AppendableRowsAndColumns aggregateWindowApertureInFlux(AggregatorFactory[] aggFactories, int lowerOffset, int upperOffset) {
        int windowSize = this.rac.numRows();
        Object[][] results = new Object[aggFactories.length][windowSize];
        int resultStorageIndex = 0;
        AtomicInteger rowIdProvider = new AtomicInteger(0);
        ColumnSelectorFactory columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(this.rac).make(rowIdProvider);
        Aggregator[][] aggregators = new Aggregator[aggFactories.length][windowSize];
        for (int i = 0; i < aggregators.length; ++i) {
            AggregatorFactory aggFactory = aggFactories[i];
            for (int j = 0; j < aggregators[i].length; ++j) {
                aggregators[i][j] = aggFactory.factorize(columnSelectorFactory);
            }
        }
        int stopIndex = Math.min(lowerOffset + 1, windowSize);
        int startIndex = 0;
        int rowId = rowIdProvider.get();
        while (rowId < windowSize) {
            for (Aggregator[] aggregator : aggregators) {
                for (int j = startIndex; j < stopIndex; ++j) {
                    aggregator[j].aggregate();
                }
            }
            if (rowId >= upperOffset) {
                for (int i = 0; i < aggregators.length; ++i) {
                    results[i][resultStorageIndex] = aggregators[i][startIndex].get();
                    aggregators[i][startIndex].close();
                    aggregators[i][startIndex] = null;
                }
                ++resultStorageIndex;
                ++startIndex;
            }
            if (stopIndex < windowSize) {
                ++stopIndex;
            }
            rowId = rowIdProvider.incrementAndGet();
        }
        while (startIndex < windowSize) {
            for (int i = 0; i < aggregators.length; ++i) {
                results[i][resultStorageIndex] = aggregators[i][startIndex].get();
                aggregators[i][startIndex].close();
                aggregators[i][startIndex] = null;
            }
            ++resultStorageIndex;
            ++startIndex;
        }
        return this.makeReturnRAC(aggFactories, results);
    }

    private AppendableRowsAndColumns makeReturnRAC(AggregatorFactory[] aggFactories, Object[][] results) {
        for (int i = 0; i < aggFactories.length; ++i) {
            this.rac.addColumn(aggFactories[i].getName(), new ObjectArrayColumn(results[i], aggFactories[i].getIntermediateType()));
        }
        return this.rac;
    }

    private static class CumulativeColumnSelectorFactory
    implements ColumnSelectorFactory {
        private final ColumnCapabilitiesImpl columnCapabilities;
        private final Object[] results;
        private int index;

        public CumulativeColumnSelectorFactory(AggregatorFactory factory, Object[] results, int initialIndex) {
            this.results = results;
            this.index = initialIndex;
            this.columnCapabilities = new ColumnCapabilitiesImpl().setHasBitmapIndexes(false).setDictionaryEncoded(false).setHasMultipleValues(false).setDictionaryValuesUnique(false).setType(factory.getIntermediateType());
        }

        public void increment() {
            ++this.index;
        }

        public void decrement() {
            --this.index;
        }

        @Override
        @Nonnull
        public DimensionSelector makeDimensionSelector(@Nonnull DimensionSpec dimensionSpec) {
            throw new UOE("combining factory shouldn't need dimensions, just columnValue, dim[%s]", dimensionSpec);
        }

        @Override
        @Nonnull
        public ColumnValueSelector makeColumnValueSelector(@Nonnull String columnName) {
            return new ObjectBasedColumnSelector(){

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Override
                @Nullable
                public Object getObject() {
                    return results[index];
                }

                @Override
                @Nonnull
                public Class classOfObject() {
                    return results[index].getClass();
                }
            };
        }

        @Override
        @Nullable
        public ColumnCapabilities getColumnCapabilities(@Nonnull String column) {
            return this.columnCapabilities;
        }
    }

    static class AggIntervalCursor {
        private AggregatorFactory[] aggFactories;
        private final AtomicInteger rowIdProvider;
        private final ColumnSelectorFactory columnSelectorFactory;
        private Interval currentRows = new Interval(0, 0);
        private final Aggregator[] aggregators;

        AggIntervalCursor(AppendableRowsAndColumns rac, AggregatorFactory[] aggFactories) {
            this.aggFactories = aggFactories;
            this.aggregators = new Aggregator[aggFactories.length];
            this.rowIdProvider = new AtomicInteger(0);
            this.columnSelectorFactory = ColumnSelectorFactoryMaker.fromRAC(rac).make(this.rowIdProvider);
            this.newAggregators();
        }

        public Object getValue(int aggIdx) {
            return DefaultFramedOnHeapAggregatable.cloneAggValue(this.aggFactories[aggIdx], this.aggregators[aggIdx].get());
        }

        public void moveTo(Interval newRows) {
            if (this.currentRows.a == newRows.a && this.currentRows.b < newRows.b) {
                for (int i = this.currentRows.b; i < newRows.b; ++i) {
                    this.aggregate(i);
                }
            } else {
                this.newAggregators();
                for (int i : newRows) {
                    this.aggregate(i);
                }
            }
            this.currentRows = newRows;
        }

        private void newAggregators() {
            for (int i = 0; i < this.aggFactories.length; ++i) {
                this.aggregators[i] = this.aggFactories[i].factorize(this.columnSelectorFactory);
            }
        }

        private void aggregate(int rowIdx) {
            this.rowIdProvider.set(rowIdx);
            for (int i = 0; i < this.aggFactories.length; ++i) {
                this.aggregators[i].aggregate();
            }
        }
    }

    static class AggInterval {
        final Interval outputRows;
        final Interval inputRows;

        public AggInterval(Interval outputRows, Interval inputRows) {
            this.outputRows = outputRows;
            this.inputRows = inputRows;
        }
    }

    static class Interval
    implements Iterable<Integer> {
        final int a;
        final int b;

        public static Interval of(int a, int b) {
            return new Interval(a, b);
        }

        public Interval(int a, int b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Iterator<Integer>(){
                int current;
                {
                    this.current = a;
                }

                @Override
                public Integer next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    return this.current++;
                }

                @Override
                public boolean hasNext() {
                    return this.current < b;
                }
            };
        }

        public String toString() {
            return StringUtils.format("Interval [%d ... %d[", this.a, this.b);
        }
    }

    static class GroupIteratorForWindowFrame
    implements Iterable<AggInterval> {
        private final int[] groupBoundaries;
        private final int numGroups;
        private final int lowerOffset;
        private final int upperOffset;

        public GroupIteratorForWindowFrame(WindowFrame frame, int[] groupBoundaries) {
            this.groupBoundaries = groupBoundaries;
            this.numGroups = groupBoundaries.length - 1;
            this.lowerOffset = frame.getLowerOffsetClamped(this.numGroups);
            this.upperOffset = Math.min(this.numGroups, frame.getUpperOffsetClamped(this.numGroups) + 1);
        }

        @Override
        public Iterator<AggInterval> iterator() {
            return new Iterator<AggInterval>(){
                int currentGroupIndex = 0;

                @Override
                public boolean hasNext() {
                    return this.currentGroupIndex < numGroups;
                }

                @Override
                public AggInterval next() {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    AggInterval r = new AggInterval(Interval.of(this.groupToRowIndex(this.relativeGroupId(0)), this.groupToRowIndex(this.relativeGroupId(1))), Interval.of(this.groupToRowIndex(this.relativeGroupId(-lowerOffset)), this.groupToRowIndex(this.relativeGroupId(upperOffset))));
                    ++this.currentGroupIndex;
                    return r;
                }

                private int groupToRowIndex(int groupId) {
                    return groupBoundaries[groupId];
                }

                private int relativeGroupId(int groupOffset) {
                    int groupIndex = DefaultFramedOnHeapAggregatable.invertedOrderForLastK(this.currentGroupIndex, numGroups, upperOffset);
                    int groupId = groupIndex + groupOffset;
                    if (groupId < 0) {
                        return 0;
                    }
                    if (groupId >= numGroups) {
                        return numGroups;
                    }
                    return groupId;
                }
            };
        }
    }

    static class ResultPopulator {
        private final Object[][] results;
        private final AggregatorFactory[] aggFactories;

        public ResultPopulator(AggregatorFactory[] aggFactories, int numRows) {
            this.aggFactories = aggFactories;
            this.results = new Object[aggFactories.length][numRows];
        }

        public void write(Interval outputRows, AggIntervalCursor aggCursor) {
            for (int col = 0; col < this.aggFactories.length; ++col) {
                Arrays.fill(this.results[col], outputRows.a, outputRows.b, aggCursor.getValue(col));
            }
        }

        public void appendTo(AppendableRowsAndColumns rac) {
            for (int i = 0; i < this.aggFactories.length; ++i) {
                rac.addColumn(this.aggFactories[i].getName(), new ObjectArrayColumn(this.results[i], this.aggFactories[i].getIntermediateType()));
            }
        }
    }
}

